% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kernel.CFM.R
\name{censored_kernel_factor_model}
\alias{censored_kernel_factor_model}
\title{Kernel Censored Factor Model}
\usage{
censored_kernel_factor_model(
  X,
  m,
  kernel_type = "rbf",
  gamma = NULL,
  max_iter = 100,
  tol = 1e-04,
  nugget = 1e-06
)
}
\arguments{
\item{X}{Data matrix (n x p)}

\item{m}{Number of factors}

\item{kernel_type}{Kernel type: "rbf" or "linear" (default: "rbf")}

\item{gamma}{Gamma parameter for RBF kernel (default: 1/p)}

\item{max_iter}{Maximum number of ECM iterations (default: 100)}

\item{tol}{Convergence tolerance (default: 1e-4)}

\item{nugget}{Numerical stability term (default: 1e-6)}
}
\value{
A list containing model results
}
\description{
Implementation of kernel-based censored factor model using kernel PCA
initialization for nonlinear factor analysis with censored data.
}
