% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{wrapper_knn}
\alias{wrapper_knn}
\title{k-Nearest Neighbors (KNN) wrapper for CCI (kknn-based)}
\usage{
wrapper_knn(
  formula,
  data,
  train_indices,
  test_indices,
  metric,
  metricfunc = NULL,
  k = 15,
  eps = 1e-15,
  positive = NULL,
  kernel = "optimal",
  distance = 2,
  ...
)
}
\arguments{
\item{formula}{Model formula}

\item{data}{Data frame}

\item{train_indices}{Indices for training rows}

\item{test_indices}{Indices for test rows}

\item{metric}{Performance metric: "RMSE" (regression), "Kappa" (classification), or "LogLoss" (classification)}

\item{metricfunc}{Optional custom metric function: function(actual, predictions, ...)}

\item{k}{Integer, number of neighbors (default 15)}

\item{eps}{Small value to avoid log(0) in LogLoss calculations. Default is 1e-15.}

\item{positive}{Character. The positive class label for binary classification (used in LogLoss). Default is NULL.}

\item{kernel}{Character. Weighting kernel for kknn. Default "optimal".}

\item{distance}{Numeric. Minkowski distance parameter. 2 = Euclidean. Default 2.}

\item{...}{Additional arguments passed to kknn::kknn (e.g., ykernel, na.action)}
}
\value{
Numeric performance metric
}
\description{
k-Nearest Neighbors (KNN) wrapper for CCI (kknn-based)
}
