% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes.t.test.R
\name{bayes.t.test}
\alias{bayes.t.test}
\alias{bayes.t.test.default}
\alias{bayes.t.test.formula}
\title{Bayesian t-test}
\usage{
bayes.t.test(x, ...)

\method{bayes.t.test}{default}(
  x,
  y = NULL,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  var.equal = TRUE,
  conf.level = 0.95,
  prior = c("jeffreys", "joint.conj"),
  m = NULL,
  n0 = NULL,
  sig.med = NULL,
  kappa = 1,
  sigmaPrior = "chisq",
  nIter = 10000,
  nBurn = 1000,
  ...
)

\method{bayes.t.test}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{any additional arguments}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of 
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}. You can specify just the initial 
letter.}

\item{mu}{a number indicating the true value of the mean (or difference in means if you are performing a two sample test).}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. 
If \code{TRUE} (default) then the pooled variance is used to estimate the variance otherwise the 
Welch (or Satterthwaite) approximation to the degrees of freedom is used. The unequal variance case is
implented using Gibbs sampling.}

\item{conf.level}{confidence level of interval.}

\item{prior}{a character string indicating which prior should be used for the means, must be one of
\code{"jeffreys"} (default) for independent Jeffreys' priors on the unknown mean(s) and variance(s), 
or \code{"joint.conj"} for a joint conjugate prior.}

\item{m}{if the joint conjugate prior is used then the user must specify a prior mean in the one-sample
or paired case, or two prior means in the two-sample case. Note that if the hypothesis is that there is no difference
between the means in the two-sample case, then the values of the prior means should usually be equal, and if so, 
then their actual values are irrelvant.This parameter is not used if the user chooses a Jeffreys' prior.}

\item{n0}{if the joint conjugate prior is used then the user must specify the prior precision 
or precisions in the two sample case that represent our level of uncertainty
about the true mean(s). This parameter is not used if the user chooses a Jeffreys' prior.}

\item{sig.med}{if the joint conjugate prior is used then the user must specify the prior median
for the unknown standard deviation. This parameter is not used if the user chooses a Jeffreys' prior.}

\item{kappa}{if the joint conjugate prior is used then the user must specify the degrees of freedom
for the inverse chi-squared distribution used for the unknown standard deviation. Usually the default
of 1 will be sufficient. This parameter is not used if the user chooses a Jeffreys' prior.}

\item{sigmaPrior}{If a two-sample t-test with unequal variances is desired then the user must choose between
using an chi-squared prior ("chisq") or a gamma prior ("gamma") for the unknown population standard deviations.
This parameter is only used if \code{var.equal} is set to \code{FALSE}.}

\item{nIter}{Gibbs sampling is used when a two-sample t-test with unequal variances is desired.
This parameter controls the sample size from the posterior distribution.}

\item{nBurn}{Gibbs sampling is used when a two-sample t-test with unequal variances is desired.
This parameter controls the number of iterations used to burn in the chains before the procedure 
starts sampling in order to reduce correlation with the starting values.}

\item{formula}{a formula of the form \code{lhs ~ rhs} where lhs is a numeric variable giving the data values and rhs a factor with two 
levels giving the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see \code{\link{model.frame}}) containing 
the variables in the formula formula. By default the variables are taken from \code{environment(formula)}.}

\item{subset}{currently ingored.}

\item{na.action}{currently ignored.}
}
\value{
A list with class "htest" containing the following components:
 \item{statistic}{the value of the t-statistic.}
 \item{parameter}{the degrees of freedom for the t-statistic.}                                                                                        
  \item{p.value}{the p-value for the test.}"                                                                                                              
  \item{conf.int}{a confidence interval for the mean appropriate to the specified alternative hypothesis.}
  \item{estimate}{the estimated mean or difference in means depending on whether it was a one-sample test or a two-sample test.}
  \item{null.value}{the specified hypothesized value of the mean or mean difference depending on whether it was a one-sample test or a two-sample test.}
  \item{alternative}{a character string describing the alternative hypothesis.}
  \item{method}{a character string indicating what type of t-test was performed.}
  \item{data.name}{a character string giving the name(s) of the data.}
  \item{result}{an object of class \code{Bolstad}}
}
\description{
Performs one and two sample t-tests (in the Bayesian hypothesis testing framework) on vectors of data
}
\section{Methods (by class)}{
\itemize{
\item \code{bayes.t.test(default)}: Bayesian t-test

\item \code{bayes.t.test(formula)}: Bayesian t-test

}}
\examples{
bayes.t.test(1:10, y = c(7:20))      # P = .3.691e-01

## Same example but with using the joint conjugate prior
## We set the prior means equal (and it doesn't matter what the value is)
## the prior precision is 0.01, which is a prior standard deviation of 10
## we're saying the true difference of the means is between [-25.7, 25.7]
## with probability equal to 0.99. The median value for the prior on sigma is 2
## and we're using a scaled inverse chi-squared prior with 1 degree of freedom
bayes.t.test(1:10, y = c(7:20), var.equal = TRUE, prior = "joint.conj", 
             m = c(0,0), n0 =  rep(0.01, 2), sig.med = 2)

##' Same example but with a large outlier. Note the assumption of equal variances isn't sensible
bayes.t.test(1:10, y = c(7:20, 200)) # P = .1979    -- NOT significant anymore

## Classical example: Student's sleep data
plot(extra ~ group, data = sleep)

## Traditional interface
with(sleep, bayes.t.test(extra[group == 1], extra[group == 2]))

## Formula interface
bayes.t.test(extra ~ group, data = sleep)
}
\author{
R Core with Bayesian internals added by James Curran
}
