% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_h.R
\name{estimate_h}
\alias{estimate_h}
\title{Estimation of the thickness of the sample}
\usage{
estimate_h(
  df = NULL,
  core = "core",
  mind = "mind_corrected",
  maxd = "maxd_corrected"
)
}
\arguments{
\item{df}{A data.frame with columns core, mind (minimum depth of the sample) and maxd (maximum depth of the sample)}

\item{core}{Character Name of the column reporting core ID.}

\item{mind}{Character Name of the column reporting the minimum depth of each sample.}

\item{maxd}{Character Name of the column reporting the maximum depth of each sample.}
}
\value{
the initial data.frame with three additional columns:
\itemize{
\item emin (estimated minimum depth of the sample)
\item emax (estimated maximum depth of the sample)
\item h (estimated thickness of the sample)
}
}
\description{
checks for space between samples and, if any, divide this space between the previous and
next sample to return sample thickness without gaps in the core
}
\examples{
bluecarbon_decompact <- decompact(bluecarbon_data)
out <- estimate_h(bluecarbon_decompact)
}
