// Generated by rstantools.  Do not edit by hand.

/*
    BinaryReplicates is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BinaryReplicates is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BinaryReplicates.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_BayesianModel_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 37> locations_array__ =
  {" (found before start of program)",
  " (in 'BayesianModel', line 26, column 2 to column 29)",
  " (in 'BayesianModel', line 27, column 2 to column 29)",
  " (in 'BayesianModel', line 28, column 2 to column 31)",
  " (in 'BayesianModel', line 44, column 2 to column 18)",
  " (in 'BayesianModel', line 45, column 2 to column 31)",
  " (in 'BayesianModel', line 47, column 4 to column 56)",
  " (in 'BayesianModel', line 48, column 4 to column 45)",
  " (in 'BayesianModel', line 46, column 17 to line 49, column 3)",
  " (in 'BayesianModel', line 46, column 2 to line 49, column 3)",
  " (in 'BayesianModel', line 32, column 2 to column 33)",
  " (in 'BayesianModel', line 32, column 28 to column 31)",
  " (in 'BayesianModel', line 32, column 25 to column 26)",
  " (in 'BayesianModel', line 33, column 2 to column 33)",
  " (in 'BayesianModel', line 33, column 28 to column 31)",
  " (in 'BayesianModel', line 33, column 25 to column 26)",
  " (in 'BayesianModel', line 34, column 2 to column 25)",
  " (in 'BayesianModel', line 36, column 4 to line 39, column 6)",
  " (in 'BayesianModel', line 35, column 17 to line 40, column 3)",
  " (in 'BayesianModel', line 35, column 2 to line 40, column 3)",
  " (in 'BayesianModel', line 14, column 2 to column 17)",
  " (in 'BayesianModel', line 15, column 8 to column 9)",
  " (in 'BayesianModel', line 15, column 2 to column 27)",
  " (in 'BayesianModel', line 16, column 8 to column 9)",
  " (in 'BayesianModel', line 16, column 2 to column 27)",
  " (in 'BayesianModel', line 17, column 2 to column 21)",
  " (in 'BayesianModel', line 18, column 2 to column 21)",
  " (in 'BayesianModel', line 19, column 2 to column 21)",
  " (in 'BayesianModel', line 20, column 2 to column 21)",
  " (in 'BayesianModel', line 21, column 2 to column 20)",
  " (in 'BayesianModel', line 22, column 2 to column 20)",
  " (in 'BayesianModel', line 44, column 8 to column 9)",
  " (in 'BayesianModel', line 45, column 8 to column 9)",
  " (in 'BayesianModel', line 4, column 4 to column 60)",
  " (in 'BayesianModel', line 5, column 4 to line 8, column 6)",
  " (in 'BayesianModel', line 9, column 4 to column 36)",
  " (in 'BayesianModel', line 3, column 54 to line 10, column 3)"};
template <typename T2__, typename T3__, typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
stan::promote_args_t<T2__, T3__, T4__>
pred(const int& s, const int& n, const T2__& p, const T3__& q, const T4__&
     theta, std::ostream* pstream__);
template <typename T2__, typename T3__, typename T4__,
          stan::require_all_t<stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>>*>
stan::promote_args_t<T2__, T3__, T4__>
pred(const int& s, const int& n, const T2__& p, const T3__& q, const T4__&
     theta, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T2__, T3__, T4__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ log_num = DUMMY_VAR__;
    current_statement__ = 33;
    log_num = (stan::math::log(theta) +
      stan::math::binomial_lpmf<false>(s, n, (1 - q)));
    local_scalar_t__ log_denom = DUMMY_VAR__;
    current_statement__ = 34;
    log_denom = stan::math::log_sum_exp(log_num, (stan::math::log1m(theta) +
                  stan::math::binomial_lpmf<false>(s, n, p)));
    current_statement__ = 35;
    return stan::math::exp((log_num - log_denom));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_BayesianModel final : public model_base_crtp<model_BayesianModel> {
private:
  int n;
  std::vector<int> si;
  std::vector<int> ni;
  double a_FP;
  double b_FP;
  double a_FN;
  double b_FN;
  double a_T;
  double b_T;
public:
  ~model_BayesianModel() {}
  model_BayesianModel(stan::io::var_context& context__, unsigned int
                      random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_BayesianModel_namespace::model_BayesianModel";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 20;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 20;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 20;
      stan::math::check_greater_or_equal(function__, "n", n, 1);
      current_statement__ = 21;
      stan::math::validate_non_negative_index("si", "n", n);
      current_statement__ = 22;
      context__.validate_dims("data initialization", "si", "int",
        std::vector<size_t>{static_cast<size_t>(n)});
      si = std::vector<int>(n, std::numeric_limits<int>::min());
      current_statement__ = 22;
      si = context__.vals_i("si");
      current_statement__ = 22;
      stan::math::check_greater_or_equal(function__, "si", si, 0);
      current_statement__ = 23;
      stan::math::validate_non_negative_index("ni", "n", n);
      current_statement__ = 24;
      context__.validate_dims("data initialization", "ni", "int",
        std::vector<size_t>{static_cast<size_t>(n)});
      ni = std::vector<int>(n, std::numeric_limits<int>::min());
      current_statement__ = 24;
      ni = context__.vals_i("ni");
      current_statement__ = 24;
      stan::math::check_greater_or_equal(function__, "ni", ni, 1);
      current_statement__ = 25;
      context__.validate_dims("data initialization", "a_FP", "double",
        std::vector<size_t>{});
      a_FP = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 25;
      a_FP = context__.vals_r("a_FP")[(1 - 1)];
      current_statement__ = 25;
      stan::math::check_greater_or_equal(function__, "a_FP", a_FP, 0);
      current_statement__ = 26;
      context__.validate_dims("data initialization", "b_FP", "double",
        std::vector<size_t>{});
      b_FP = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 26;
      b_FP = context__.vals_r("b_FP")[(1 - 1)];
      current_statement__ = 26;
      stan::math::check_greater_or_equal(function__, "b_FP", b_FP, 0);
      current_statement__ = 27;
      context__.validate_dims("data initialization", "a_FN", "double",
        std::vector<size_t>{});
      a_FN = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 27;
      a_FN = context__.vals_r("a_FN")[(1 - 1)];
      current_statement__ = 27;
      stan::math::check_greater_or_equal(function__, "a_FN", a_FN, 0);
      current_statement__ = 28;
      context__.validate_dims("data initialization", "b_FN", "double",
        std::vector<size_t>{});
      b_FN = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 28;
      b_FN = context__.vals_r("b_FN")[(1 - 1)];
      current_statement__ = 28;
      stan::math::check_greater_or_equal(function__, "b_FN", b_FN, 0);
      current_statement__ = 29;
      context__.validate_dims("data initialization", "a_T", "double",
        std::vector<size_t>{});
      a_T = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 29;
      a_T = context__.vals_r("a_T")[(1 - 1)];
      current_statement__ = 29;
      stan::math::check_greater_or_equal(function__, "a_T", a_T, 0);
      current_statement__ = 30;
      context__.validate_dims("data initialization", "b_T", "double",
        std::vector<size_t>{});
      b_T = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 30;
      b_T = context__.vals_r("b_T")[(1 - 1)];
      current_statement__ = 30;
      stan::math::check_greater_or_equal(function__, "b_T", b_T, 0);
      current_statement__ = 31;
      stan::math::validate_non_negative_index("Ti", "n", n);
      current_statement__ = 32;
      stan::math::validate_non_negative_index("posterior_prob", "n", n);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_BayesianModel";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_BayesianModel_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ p = DUMMY_VAR__;
      current_statement__ = 1;
      p = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(0,
            0.5, lp__);
      local_scalar_t__ q = DUMMY_VAR__;
      current_statement__ = 2;
      q = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(0,
            0.5, lp__);
      local_scalar_t__ theta = DUMMY_VAR__;
      current_statement__ = 3;
      theta = in__.template read_constrain_lub<local_scalar_t__,
                jacobian__>(0, 1, lp__);
      {
        current_statement__ = 10;
        lp_accum__.add(stan::math::beta_lpdf<propto__>(p, a_FP, b_FP));
        current_statement__ = 12;
        if (stan::math::logical_lt(p, 0)) {
          current_statement__ = 12;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 11;
          if (stan::math::logical_gt(p, 0.5)) {
            current_statement__ = 11;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 11;
            lp_accum__.add(-stan::math::log_diff_exp(
                              stan::math::beta_lcdf(0.5, a_FP, b_FP),
                              stan::math::beta_lcdf(0, a_FP, b_FP)));
          }
        }
        current_statement__ = 13;
        lp_accum__.add(stan::math::beta_lpdf<propto__>(q, a_FN, b_FN));
        current_statement__ = 15;
        if (stan::math::logical_lt(q, 0)) {
          current_statement__ = 15;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 14;
          if (stan::math::logical_gt(q, 0.5)) {
            current_statement__ = 14;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 14;
            lp_accum__.add(-stan::math::log_diff_exp(
                              stan::math::beta_lcdf(0.5, a_FN, b_FN),
                              stan::math::beta_lcdf(0, a_FN, b_FN)));
          }
        }
        current_statement__ = 16;
        lp_accum__.add(stan::math::beta_lpdf<propto__>(theta, a_T, b_T));
        current_statement__ = 19;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 17;
          lp_accum__.add(stan::math::log_sum_exp((stan::math::log(theta) +
                           stan::math::binomial_lpmf<false>(
                             stan::model::rvalue(si, "si",
                               stan::model::index_uni(i)),
                             stan::model::rvalue(ni, "ni",
                               stan::model::index_uni(i)), (1 - q))),
                           (stan::math::log1m(theta) +
                           stan::math::binomial_lpmf<false>(
                             stan::model::rvalue(si, "si",
                               stan::model::index_uni(i)),
                             stan::model::rvalue(ni, "ni",
                               stan::model::index_uni(i)), p))));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_BayesianModel_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double p = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      p = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(0,
            0.5, lp__);
      double q = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      q = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(0,
            0.5, lp__);
      double theta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      theta = in__.template read_constrain_lub<local_scalar_t__,
                jacobian__>(0, 1, lp__);
      out__.write(p);
      out__.write(q);
      out__.write(theta);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<int> Ti =
        std::vector<int>(n, std::numeric_limits<int>::min());
      std::vector<double> posterior_prob =
        std::vector<double>(n, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 9;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 6;
        stan::model::assign(posterior_prob,
          pred(stan::model::rvalue(si, "si", stan::model::index_uni(i)),
            stan::model::rvalue(ni, "ni", stan::model::index_uni(i)), p, q,
            theta, pstream__), "assigning variable posterior_prob",
          stan::model::index_uni(i));
        current_statement__ = 7;
        stan::model::assign(Ti,
          stan::math::bernoulli_rng(
            stan::model::rvalue(posterior_prob, "posterior_prob",
              stan::model::index_uni(i)), base_rng__),
          "assigning variable Ti", stan::model::index_uni(i));
      }
      out__.write(Ti);
      out__.write(posterior_prob);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ p = DUMMY_VAR__;
      current_statement__ = 1;
      p = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 0.5, p);
      local_scalar_t__ q = DUMMY_VAR__;
      current_statement__ = 2;
      q = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 0.5, q);
      local_scalar_t__ theta = DUMMY_VAR__;
      current_statement__ = 3;
      theta = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 1, theta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "p", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "q", "double",
        std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "theta", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ p = DUMMY_VAR__;
      current_statement__ = 1;
      p = context__.vals_r("p")[(1 - 1)];
      out__.write_free_lub(0, 0.5, p);
      local_scalar_t__ q = DUMMY_VAR__;
      current_statement__ = 2;
      q = context__.vals_r("q")[(1 - 1)];
      out__.write_free_lub(0, 0.5, q);
      local_scalar_t__ theta = DUMMY_VAR__;
      current_statement__ = 3;
      theta = context__.vals_r("theta")[(1 - 1)];
      out__.write_free_lub(0, 1, theta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"p", "q", "theta"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"Ti", "posterior_prob"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n)},
             std::vector<size_t>{static_cast<size_t>(n)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "p");
    param_names__.emplace_back(std::string() + "q");
    param_names__.emplace_back(std::string() + "theta");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "Ti" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "posterior_prob" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "p");
    param_names__.emplace_back(std::string() + "q");
    param_names__.emplace_back(std::string() + "theta");
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "Ti" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        param_names__.emplace_back(std::string() + "posterior_prob" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"p\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"q\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"Ti\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n) + ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"posterior_prob\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"p\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"q\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"Ti\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n) + ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"posterior_prob\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((n + n));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((1 + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((n + n));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_BayesianModel_namespace::model_BayesianModel;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_BayesianModel_namespace::profiles__;
}
#endif
#endif
