% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShortTimeEffects.R
\name{ShortTimeEffects}
\alias{ShortTimeEffects}
\title{Perform comparison between LLD50 at 2 days and at 10 days
as for EFSA revised guideline (2023) - Section 6.6}
\usage{
ShortTimeEffects(
  object,
  fullcalculation = FALSE,
  concRange = NULL,
  nPoints = NULL,
  ncores = NULL
)
}
\arguments{
\item{object}{An object used to select a method}

\item{fullcalculation}{Compute the LDD50 from day 1 to day 10 of the Chronic test.
This can increase the computation time}

\item{concRange}{Argument of LCx, range of concentrations to find LDD50}

\item{nPoints}{Argument of LCx, Number of time point in \code{concRange} between 0 and the
maximal concentration. 100 by default.}

\item{ncores}{Argument of LCx, number of cores for parallelization}
}
\value{
A object of class \code{ggplot} containing the graph of the comparison
between LDD50 at day 2 and day 10 and the data.frame with the plotted values.
}
\description{
When class of \code{object} is \code{beeSurvFit},
see \link[=ShortTimeEffects.beeSurvFit]{ShortTimeEffects.beeSurvFit}.
}
\details{
Copyright 2024 C. Romoli, ibacon GmbH
}
