/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;

public class DeltaExchangeOperator
extends AbstractAdaptableOperator {
    private Parameter parameter = null;
    private final int[] parameterWeights;
    private double delta = 0.02;
    private boolean isIntegerOperator = false;

    public DeltaExchangeOperator(Parameter parameter, double d) {
        super(AdaptationMode.ADAPTATION_ON);
        this.parameter = parameter;
        this.delta = d;
        this.setWeight(1.0);
        this.isIntegerOperator = false;
        this.parameterWeights = new int[parameter.getDimension()];
        for (int i = 0; i < this.parameterWeights.length; ++i) {
            this.parameterWeights[i] = 1;
        }
    }

    public DeltaExchangeOperator(Parameter parameter, int[] nArray, double d, double d2, boolean bl, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.parameter = parameter;
        this.delta = d;
        this.setWeight(d2);
        this.isIntegerOperator = bl;
        this.parameterWeights = nArray;
        if (bl && d != (double)Math.round(d)) {
            throw new IllegalArgumentException("Can't be an integer operator if delta is not integer");
        }
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public final double doOperation() {
        int n;
        int n2 = this.parameter.getDimension();
        int n3 = n = MathUtils.nextInt(n2);
        while (n == n3) {
            n3 = MathUtils.nextInt(n2);
        }
        double d = this.parameter.getParameterValue(n);
        double d2 = this.parameter.getParameterValue(n3);
        if (this.isIntegerOperator) {
            int n4 = MathUtils.nextInt((int)Math.round(this.delta)) + 1;
            if (this.parameterWeights[n] != this.parameterWeights[n3]) {
                throw new RuntimeException();
            }
            d = Math.round(d - (double)n4);
            d2 = Math.round(d2 + (double)n4);
        } else {
            double d3 = MathUtils.nextDouble() * this.delta;
            d -= d3;
            d2 = this.parameterWeights[n] != this.parameterWeights[n3] ? (d2 += d3 * (double)this.parameterWeights[n] / (double)this.parameterWeights[n3]) : (d2 += d3);
        }
        Bounds<Double> bounds = this.parameter.getBounds();
        if (d < bounds.getLowerLimit(n) || d > bounds.getUpperLimit(n) || d2 < bounds.getLowerLimit(n3) || d2 > bounds.getUpperLimit(n3)) {
            return Double.NEGATIVE_INFINITY;
        }
        this.parameter.setParameterValue(n, d);
        this.parameter.setParameterValue(n3, d2);
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return "deltaExchange(" + this.parameter.getParameterName() + ")";
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.delta);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.delta = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.delta;
    }

    @Override
    public String getAdaptableParameterName() {
        return "delta";
    }

    public String toString() {
        return this.getOperatorName() + "(windowsize=" + this.delta + ")";
    }
}

