/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.tree.Tree;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.RateRescalingScheme;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.MultivariateTraitDebugUtilities;
import dr.evomodel.treedatalikelihood.continuous.RepeatedMeasuresTraitDataModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.AbstractVarianceProportionStatistic;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.TreeVarianceSums;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.math.matrixAlgebra.Matrix;

public class VarianceProportionStatistic
extends AbstractVarianceProportionStatistic
implements VariableListener,
ModelListener {
    private final MultivariateDiffusionModel diffusionModel;
    private final RepeatedMeasuresTraitDataModel repeatedMeasuresTraitDataModel;
    private final TreeVarianceSums treeSums;
    private Matrix diffusionVariance;
    private Matrix samplingVariance;
    private boolean treeKnown = false;
    private boolean varianceKnown = false;

    public VarianceProportionStatistic(Tree tree, TreeDataLikelihood treeDataLikelihood, RepeatedMeasuresTraitDataModel repeatedMeasuresTraitDataModel, MultivariateDiffusionModel multivariateDiffusionModel, AbstractVarianceProportionStatistic.MatrixRatios matrixRatios) {
        super(tree, treeDataLikelihood, repeatedMeasuresTraitDataModel, matrixRatios);
        this.repeatedMeasuresTraitDataModel = repeatedMeasuresTraitDataModel;
        this.diffusionModel = multivariateDiffusionModel;
        this.treeSums = new TreeVarianceSums(0.0, 0.0);
        this.diffusionVariance = null;
        this.samplingVariance = null;
        if (this.isTreeRandom.booleanValue()) {
            ((AbstractModel)((Object)tree)).addModelListener(this);
        }
        multivariateDiffusionModel.getPrecisionParameter().addParameterListener(this);
        repeatedMeasuresTraitDataModel.getExtensionPrecision().addParameterListener(this);
    }

    @Override
    protected void updateVarianceComponents() {
        double d = this.tree.getExternalNodeCount();
        double d2 = this.treeSums.getDiagonalSum() / d - this.treeSums.getTotalSum() / (d * d);
        double d3 = (d - 1.0) / d;
        for (int i = 0; i < this.dimTrait; ++i) {
            this.diffusionComponent.set(i, i, d2 * this.diffusionVariance.component(i, i));
            this.samplingComponent.set(i, i, d3 * this.samplingVariance.component(i, i));
            for (int j = i + 1; j < this.dimTrait; ++j) {
                double d4 = d2 * this.diffusionVariance.component(i, j);
                double d5 = d3 * this.samplingVariance.component(i, j);
                this.diffusionComponent.set(i, j, d4);
                this.samplingComponent.set(i, j, d5);
                this.diffusionComponent.set(j, i, d4);
                this.samplingComponent.set(j, i, d5);
            }
        }
    }

    @Override
    protected boolean needToUpdate(int n) {
        boolean bl = false;
        if (!this.treeKnown) {
            this.updateTreeSums();
            this.treeKnown = true;
            bl = true;
        }
        if (!this.varianceKnown) {
            this.samplingVariance = this.repeatedMeasuresTraitDataModel.getSamplingVariance();
            this.diffusionVariance = new Matrix(this.diffusionModel.getPrecisionmatrix()).inverse();
            this.varianceKnown = true;
            bl = true;
        }
        return bl;
    }

    private void updateTreeSums() {
        double d = MultivariateTraitDebugUtilities.getVarianceDiagonalSum(this.tree, this.treeLikelihood.getBranchRateModel(), 1.0);
        double d2 = MultivariateTraitDebugUtilities.getVarianceOffDiagonalSum(this.tree, this.treeLikelihood.getBranchRateModel(), 1.0);
        RateRescalingScheme rateRescalingScheme = this.treeLikelihood.getDataLikelihoodDelegate().getRateRescalingScheme();
        double d3 = 1.0;
        if (rateRescalingScheme == RateRescalingScheme.TREE_HEIGHT) {
            d3 = this.tree.getNodeHeight(this.tree.getRoot());
        } else {
            if (rateRescalingScheme == RateRescalingScheme.TREE_LENGTH) {
                throw new RuntimeException("VarianceProportionStatistic not yet implemented for traitDataLikelihood argument useTreeLength='true'.");
            }
            if (rateRescalingScheme != RateRescalingScheme.NONE) {
                throw new RuntimeException("VarianceProportionStatistic not yet implemented for RateRescalingScheme" + rateRescalingScheme.getText() + ".");
            }
        }
        this.treeSums.setDiagonalSum(d / d3);
        this.treeSums.setTotalSum((d + d2) / d3);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        assert (variable == this.repeatedMeasuresTraitDataModel.getExtensionPrecision() || variable == this.diffusionModel.getPrecisionParameter());
        this.varianceKnown = false;
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        assert (model == this.tree);
        if (!this.isTreeRandom.booleanValue()) {
            throw new IllegalStateException("Attempting to change a fixed tree");
        }
        this.treeKnown = false;
    }

    @Override
    public void modelRestored(Model model) {
    }
}

