/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import com.github.lbfgs4j.LbfgsMinimizer;
import com.github.lbfgs4j.liblbfgs.Function;
import com.github.lbfgs4j.liblbfgs.Lbfgs;
import com.github.lbfgs4j.liblbfgs.LbfgsConstant;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.MultivariateFunction;
import dr.math.NumericalDerivative;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.Vector;
import dr.math.matrixAlgebra.WrappedVector;
import dr.util.Timer;
import dr.util.Transform;
import dr.xml.Reportable;

public class MaximizerWrtParameter
implements Reportable {
    private final GradientWrtParameterProvider gradient;
    private final GradientType gradientType;
    private final Parameter parameter;
    private final Likelihood likelihood;
    private final Transform transform;
    private final Function function;
    private final Settings settings;
    private double time = 0.0;
    private long count = 0L;
    private double minimumValue = Double.NaN;
    private double[] minimumPoint = null;

    public MaximizerWrtParameter(Likelihood likelihood, Parameter parameter, GradientWrtParameterProvider gradientWrtParameterProvider, Transform transform, Settings settings) {
        this.likelihood = likelihood;
        this.parameter = parameter;
        this.transform = transform;
        if (gradientWrtParameterProvider == null) {
            this.gradient = this.constructGradient();
            this.gradientType = GradientType.NUMERICAL;
        } else {
            this.gradient = gradientWrtParameterProvider;
            this.gradientType = GradientType.ANALYTIC;
        }
        this.function = this.constructFunction();
        this.settings = settings;
    }

    public Likelihood getLikelihood() {
        return this.likelihood;
    }

    public double[] getMinimumPoint(boolean bl) {
        if (bl && this.transform != null) {
            return this.transform.inverse(this.minimumPoint, 0, this.minimumPoint.length);
        }
        return this.minimumPoint;
    }

    public GradientWrtParameterProvider getGradient() {
        return this.gradient;
    }

    public boolean wasExecuted() {
        return this.function != null;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Function getFunction() {
        return this.function;
    }

    public void maximize() {
        LbfgsConstant.LBFGS_Param lBFGS_Param = Lbfgs.defaultParams();
        if (this.settings.numberIterations > 0) {
            lBFGS_Param.max_iterations = this.settings.numberIterations;
        }
        LbfgsMinimizer lbfgsMinimizer = new LbfgsMinimizer(lBFGS_Param, this.settings.printToScreen);
        double[] dArray = null;
        if (this.settings.startAtCurrentState) {
            dArray = this.parameter.getParameterValues();
            if (this.transform != null) {
                dArray = this.transform.transform(dArray, 0, dArray.length);
            }
        }
        Timer timer = new Timer();
        timer.start();
        this.minimumPoint = lbfgsMinimizer.minimize(this.function, dArray);
        timer.stop();
        this.time += timer.toSeconds();
        this.minimumValue = this.function.valueAt(this.minimumPoint);
        if (this.transform != null) {
            ReadableVector.Utils.setParameter((ReadableVector)new WrappedVector.Raw(this.transform.inverse(this.minimumPoint, 0, this.minimumPoint.length)), this.parameter);
        } else {
            ReadableVector.Utils.setParameter((ReadableVector)new WrappedVector.Raw(this.minimumPoint), this.parameter);
        }
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.function == null) {
            stringBuilder.append("Not yet executed.");
        } else {
            if (this.transform != null) {
                stringBuilder.append("Gradient is taken with respect to the transformed paramter values.\n");
                stringBuilder.append("Untransformed X: ").append(new Vector(this.transform.inverse(this.minimumPoint, 0, this.minimumPoint.length))).append("\n");
            }
            stringBuilder.append("X: ").append(new Vector(this.minimumPoint)).append("\n");
            stringBuilder.append("Gradient: ").append(new Vector(this.function.gradientAt(this.minimumPoint))).append("\n");
            stringBuilder.append("Gradient type: ").append((Object)this.gradientType).append("\n");
            stringBuilder.append("Fx: ").append(this.minimumValue).append("\n");
            stringBuilder.append("Time: ").append(this.time).append("s\n");
            stringBuilder.append("Count: ").append(this.count).append("\n");
        }
        return stringBuilder.toString();
    }

    private double evaluateLogLikelihood() {
        ++this.count;
        return this.likelihood.getLogLikelihood();
    }

    private Function constructFunction() {
        return new Function(){

            @Override
            public int getDimension() {
                return MaximizerWrtParameter.this.gradient.getDimension();
            }

            @Override
            public double valueAt(double[] dArray) {
                if (MaximizerWrtParameter.this.transform != null) {
                    dArray = MaximizerWrtParameter.this.transform.inverse(dArray, 0, dArray.length);
                }
                ReadableVector.Utils.setParameter((ReadableVector)new WrappedVector.Raw(dArray), MaximizerWrtParameter.this.parameter);
                if (((MaximizerWrtParameter)MaximizerWrtParameter.this).settings.includeJacobian) {
                    return -MaximizerWrtParameter.this.evaluateLogLikelihood() - MaximizerWrtParameter.this.transform.logJacobian(dArray, 0, dArray.length);
                }
                return -MaximizerWrtParameter.this.evaluateLogLikelihood();
            }

            @Override
            public double[] gradientAt(double[] dArray) {
                if (MaximizerWrtParameter.this.transform != null) {
                    dArray = MaximizerWrtParameter.this.transform.inverse(dArray, 0, dArray.length);
                }
                ReadableVector.Utils.setParameter((ReadableVector)new WrappedVector.Raw(dArray), MaximizerWrtParameter.this.parameter);
                double[] dArray2 = MaximizerWrtParameter.this.gradient.getGradientLogDensity();
                if (MaximizerWrtParameter.this.transform != null) {
                    dArray2 = ((MaximizerWrtParameter)MaximizerWrtParameter.this).settings.includeJacobian ? MaximizerWrtParameter.this.transform.updateGradientLogDensity(dArray2, dArray, 0, dArray.length) : MaximizerWrtParameter.this.transform.updateGradientUnWeightedLogDensity(dArray2, dArray, 0, dArray.length);
                }
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = -dArray2[i];
                }
                return dArray2;
            }
        };
    }

    private GradientWrtParameterProvider constructGradient() {
        final MultivariateFunction multivariateFunction = new MultivariateFunction(){

            @Override
            public double evaluate(double[] dArray) {
                ReadableVector.Utils.setParameter((ReadableVector)new WrappedVector.Raw(dArray), MaximizerWrtParameter.this.parameter);
                return MaximizerWrtParameter.this.evaluateLogLikelihood();
            }

            @Override
            public int getNumArguments() {
                return MaximizerWrtParameter.this.parameter.getDimension();
            }

            @Override
            public double getLowerBound(int n) {
                return Double.NEGATIVE_INFINITY;
            }

            @Override
            public double getUpperBound(int n) {
                return Double.POSITIVE_INFINITY;
            }
        };
        return new GradientWrtParameterProvider(){

            @Override
            public Likelihood getLikelihood() {
                return MaximizerWrtParameter.this.likelihood;
            }

            @Override
            public Parameter getParameter() {
                return MaximizerWrtParameter.this.parameter;
            }

            @Override
            public int getDimension() {
                return MaximizerWrtParameter.this.parameter.getDimension();
            }

            @Override
            public double[] getGradientLogDensity() {
                return NumericalDerivative.gradient(multivariateFunction, MaximizerWrtParameter.this.parameter.getParameterValues());
            }
        };
    }

    public static class Settings {
        int numberIterations;
        boolean startAtCurrentState;
        boolean printToScreen;
        boolean includeJacobian;

        public Settings(int n, boolean bl, boolean bl2, boolean bl3) {
            this.numberIterations = n;
            this.startAtCurrentState = bl;
            this.printToScreen = bl2;
            this.includeJacobian = bl3;
        }
    }

    private static enum GradientType {
        ANALYTIC("analytic"),
        NUMERICAL("numerical");

        private String type;

        private GradientType(String string2) {
            this.type = string2;
        }

        public String toString() {
            return this.type;
        }
    }
}

