/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.FastMatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultTreeModel
extends TreeModel {
    public static final String TREE_MODEL = "treeModel";
    private static final boolean TEST_NODE_BOUNDS = false;
    boolean heightBoundsSetup = false;
    private Node oldRoot;
    private Node root = null;
    private int storedRootNumber;
    private Node[] nodes = null;
    private Node[] storedNodes = null;
    private final int nodeCount;
    private final int externalNodeCount;
    private final int internalNodeCount;
    private boolean hasRates = false;
    private boolean hasTraits = false;
    private boolean isTipDateSampled = false;
    private final Map<Parameter, Node> parameterNodeMap = new HashMap<Parameter, Node>();

    public DefaultTreeModel(String string) {
        super(string, true);
        this.nodeCount = 0;
        this.externalNodeCount = 0;
        this.internalNodeCount = 0;
    }

    public DefaultTreeModel(Tree tree) {
        this(TREE_MODEL, tree, false, false, false);
    }

    public DefaultTreeModel(String string, Tree tree) {
        this(string, tree, false, false);
    }

    public DefaultTreeModel(String string, Tree tree, boolean bl, boolean bl2) {
        this(string, tree, false, bl, bl2);
        this.setId(string);
    }

    public DefaultTreeModel(String string, Tree tree, boolean bl, boolean bl2, boolean bl3) {
        super(string, !bl3);
        FlexibleTree flexibleTree = new FlexibleTree(tree, bl);
        flexibleTree.resolveTree();
        if (!bl2) {
            MutableTree.Utils.correctHeightsForTips(flexibleTree);
        }
        Node node = new Node(flexibleTree, flexibleTree.getRoot());
        this.internalNodeCount = flexibleTree.getInternalNodeCount();
        this.externalNodeCount = flexibleTree.getExternalNodeCount();
        this.nodeCount = this.internalNodeCount + this.externalNodeCount;
        this.nodes = new Node[this.nodeCount];
        this.storedNodes = new Node[this.nodeCount];
        int n = 0;
        int n2 = this.externalNodeCount;
        this.root = node;
        do {
            if ((node = (Node)TreeUtils.postorderSuccessor(this, node)).isExternal()) {
                node.number = n;
                this.nodes[n] = node;
                this.storedNodes[n] = new Node();
                this.storedNodes[n].taxon = node.taxon;
                this.storedNodes[n].number = n;
                ++n;
                continue;
            }
            node.number = n2;
            this.nodes[n2] = node;
            this.storedNodes[n2] = new Node();
            this.storedNodes[n2].number = n2;
            ++n2;
        } while (node != this.root);
        this.setupHeightBounds();
    }

    public void setupHeightBounds() {
        if (this.heightBoundsSetup) {
            throw new IllegalArgumentException("Node height bounds set up twice");
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            this.nodes[i].setupHeightBounds();
        }
        this.heightBoundsSetup = true;
    }

    public void pushTreeChangedEvent(Node node, Parameter parameter) {
        this.pushTreeChangedEvent(TreeChangedEvent.create(node, parameter, parameter == node.heightParameter));
    }

    public void pushTreeChangedEvent(Node node, Parameter parameter, int n) {
        this.pushTreeChangedEvent(TreeChangedEvent.create(node, parameter, n, parameter == node.heightParameter));
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        Node node = this.getNodeOfParameter((Parameter)variable);
        if (changeType == Variable.ChangeType.ALL_VALUES_CHANGED) {
            this.pushTreeChangedEvent(node, (Parameter)variable);
        } else {
            this.pushTreeChangedEvent(node, (Parameter)variable, n);
        }
    }

    @Override
    public boolean beginTreeEdit() {
        this.oldRoot = this.root;
        return super.beginTreeEdit();
    }

    @Override
    public void endTreeEdit() {
        super.endTreeEdit();
        if (this.root != this.oldRoot) {
            this.swapParameterObjects(this.oldRoot, this.root);
        }
    }

    public boolean hasRates() {
        return this.hasRates;
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return ((Node)nodeRef).getHeight();
    }

    public final double getNodeHeightUpper(NodeRef nodeRef) {
        return ((Node)nodeRef).heightParameter.getBounds().getUpperLimit(0);
    }

    public final double getNodeHeightLower(NodeRef nodeRef) {
        return ((Node)nodeRef).heightParameter.getBounds().getLowerLimit(0);
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        if (!this.hasRates) {
            return 1.0;
        }
        return ((Node)nodeRef).getRate();
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        if (string.equals("rate")) {
            return this.getNodeRate(nodeRef);
        }
        return null;
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        return new Iterator(){
            int i = 0;
            String[] attributes = new String[]{"rate"};

            @Override
            public boolean hasNext() {
                return this.i < this.attributes.length;
            }

            public Object next() {
                return this.attributes[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("can't remove from this iterator!");
            }
        };
    }

    public boolean hasNodeTraits() {
        return this.hasTraits;
    }

    public Map<String, Parameter> getTraitMap(NodeRef nodeRef) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        return ((Node)nodeRef).getTraitMap();
    }

    public double getNodeTrait(NodeRef nodeRef, String string) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        return ((Node)nodeRef).getTrait(string);
    }

    public Parameter getNodeTraitParameter(NodeRef nodeRef, String string) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        return ((Node)nodeRef).getTraitParameter(string);
    }

    @Override
    public double[] getMultivariateNodeTrait(NodeRef nodeRef, String string) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        return ((Node)nodeRef).getMultivariateTrait(string);
    }

    public final void swapAllTraits(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        this.swapAllTraits((Node)nodeRef, (Node)nodeRef2);
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return ((Node)nodeRef).taxon;
    }

    public void setNodeTaxon(NodeRef nodeRef, Taxon taxon) {
        ((Node)nodeRef).taxon = taxon;
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return ((Node)nodeRef).isExternal();
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return nodeRef == this.root;
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        return ((Node)nodeRef).getChildCount();
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return ((Node)nodeRef).getChild(n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        return ((Node)nodeRef).parent;
    }

    @Override
    public NodeRef getExternalNode(int n) {
        return this.nodes[n];
    }

    @Override
    public NodeRef getInternalNode(int n) {
        return this.nodes[n + this.externalNodeCount];
    }

    @Override
    public NodeRef getNode(int n) {
        return this.nodes[n];
    }

    @Override
    public NodeRef[] getNodes() {
        return this.nodes;
    }

    @Override
    public int getExternalNodeCount() {
        return this.externalNodeCount;
    }

    @Override
    public int getInternalNodeCount() {
        return this.internalNodeCount;
    }

    @Override
    public NodeRef getRoot() {
        return this.root;
    }

    public void setTipDateSampled(boolean bl) {
        this.isTipDateSampled = bl;
    }

    @Override
    public boolean isTipDateSampled() {
        return this.isTipDateSampled;
    }

    @Override
    public void setRoot(NodeRef nodeRef) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        this.root = (Node)nodeRef;
        this.pushTreeChangedEvent(this.root);
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        if (node.hasChild(node2)) {
            throw new IllegalArgumentException("Child already exists in parent");
        }
        node.addChild(node2);
        this.pushTreeChangedEvent(node);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.removeChild(node2);
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean isTreeValid() {
        for (Node node : this.nodes) {
            if (node.heightParameter.isWithinBounds()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        ((Node)nodeRef).setHeight(d);
    }

    @Override
    public void setNodeHeightQuietly(NodeRef nodeRef, double d) {
        ((Node)nodeRef).setHeightQuietly(d);
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        if (!this.hasRates) {
            throw new IllegalArgumentException("Rate parameters have not been created");
        }
        ((Node)nodeRef).setRate(d);
    }

    public void setNodeTrait(NodeRef nodeRef, String string, double d) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        ((Node)nodeRef).setTrait(string, d);
    }

    @Override
    public void setMultivariateTrait(NodeRef nodeRef, String string, double[] dArray) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        ((Node)nodeRef).setMultivariateTrait(string, dArray);
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("TreeModel cannot have branch lengths set");
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        throw new UnsupportedOperationException("TreeModel does not use NodeAttributes");
    }

    @Override
    protected void storeState() {
        this.copyNodeStructure(this.storedNodes);
        this.storedRootNumber = this.root.getNumber();
    }

    @Override
    protected void restoreState() {
        Node[] nodeArray = this.storedNodes;
        this.storedNodes = this.nodes;
        this.nodes = nodeArray;
        this.root = this.nodes[this.storedRootNumber];
        this.remapParameterNodes();
    }

    private void remapParameterNodes() {
        for (Node node : this.nodes) {
            this.parameterNodeMap.put(node.heightParameter, node);
            if (this.hasRates) {
                this.parameterNodeMap.put(node.rateParameter, node);
            }
            if (!this.hasTraits) continue;
            for (Parameter parameter : node.traitParameters.values()) {
                this.parameterNodeMap.put(parameter, node);
            }
        }
    }

    @Override
    protected void acceptState() {
    }

    private void copyNodeStructure(Node[] nodeArray) {
        if (this.nodes.length != nodeArray.length) {
            throw new IllegalArgumentException("Node arrays are of different lengths");
        }
        int n = this.nodes.length;
        for (int i = 0; i < n; ++i) {
            Node node = this.nodes[i];
            Node node2 = nodeArray[i];
            node2.heightParameter = node.heightParameter;
            node2.rateParameter = node.rateParameter;
            node2.traitParameters = node.traitParameters;
            node2.parent = node.parent != null ? this.storedNodes[node.parent.getNumber()] : null;
            node2.leftChild = node.leftChild != null ? this.storedNodes[node.leftChild.getNumber()] : null;
            node2.rightChild = node.rightChild != null ? this.storedNodes[node.rightChild.getNumber()] : null;
        }
    }

    public void adoptTreeStructure(Tree tree) {
        for (int i = this.externalNodeCount; i < this.nodeCount; ++i) {
            int n = this.nodes[i].getChildCount();
            for (int j = 0; j < n; ++j) {
                this.nodes[i].removeChild(j);
            }
        }
        this.addNodeStructure(tree, tree.getRoot());
        this.remapParameterNodes();
    }

    @Override
    public void adoptTreeStructure(int[] nArray, double[] dArray, int[] nArray2, String[] stringArray) {
        int n;
        int n2;
        int[] nArray3 = this.createNodeMap(stringArray);
        if (this.nodeCount != nArray.length) {
            throw new RuntimeException("Incorrect number of edges provided: " + nArray.length + " versus " + this.nodeCount + " nodes.");
        }
        for (n2 = this.externalNodeCount; n2 < this.nodeCount; ++n2) {
            n = this.nodes[n2].getChildCount();
            for (int i = 0; i < n; ++i) {
                this.nodes[n2].removeChild(i);
            }
        }
        for (n2 = 0; n2 < this.getExternalNodeCount(); ++n2) {
            this.setNodeHeight(this.getExternalNode(nArray3[n2]), dArray[n2]);
        }
        for (n2 = 0; n2 < this.getExternalNodeCount() - 1; ++n2) {
            this.setNodeHeight(this.getInternalNode(n2), dArray[this.getExternalNodeCount() + n2]);
        }
        n2 = -1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != -1) {
                if (n < this.getExternalNodeCount()) {
                    this.addChild(this.getNode(nArray[n]), this.getExternalNode(nArray3[n]));
                    System.out.println("external: " + nArray[n] + " > " + nArray3[n]);
                    continue;
                }
                this.addChild(this.getNode(nArray[n]), this.getNode(n));
                System.out.println("internal: " + nArray[n] + " > " + n);
                continue;
            }
            n2 = n;
        }
        for (n = 0; n < nArray.length; ++n) {
            Node node;
            Node node2;
            if (nArray[n] == -1) continue;
            if (n < this.externalNodeCount) {
                if (nArray2[n] != 0 || this.nodes[nArray[n]].getChild(0) == this.nodes[nArray3[n]]) continue;
                node2 = this.nodes[nArray[n]].removeChild(0);
                node = this.nodes[nArray[n]].removeChild(1);
                this.nodes[nArray[n]].addChild(node);
                this.nodes[nArray[n]].addChild(node2);
                continue;
            }
            if (nArray2[n] != 0 || this.nodes[nArray[n]].getChild(0) == this.nodes[n]) continue;
            node2 = this.nodes[nArray[n]].removeChild(0);
            node = this.nodes[nArray[n]].removeChild(1);
            this.nodes[nArray[n]].addChild(node);
            this.nodes[nArray[n]].addChild(node2);
        }
        this.remapParameterNodes();
        this.setRoot(this.nodes[n2]);
    }

    private void addNodeStructure(Tree tree, NodeRef nodeRef) {
        int n;
        Node node = null;
        node = tree.isExternal(nodeRef) ? this.nodes[this.getTaxonIndex(tree.getTaxonId(nodeRef.getNumber()))] : this.nodes[nodeRef.getNumber()];
        this.setNodeHeight(node, tree.getNodeHeight(nodeRef));
        for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
            if (tree.isExternal(tree.getChild(nodeRef, n))) {
                this.addChild(node, this.nodes[this.getTaxonIndex(tree.getTaxonId(tree.getChild(nodeRef, n).getNumber()))]);
                continue;
            }
            this.addChild(node, this.nodes[tree.getChild(nodeRef, n).getNumber()]);
        }
        this.pushTreeChangedEvent(node);
        if (!tree.isExternal(nodeRef)) {
            for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
                this.addNodeStructure(tree, tree.getChild(nodeRef, n));
            }
        }
    }

    @Override
    public int getStatisticCount() {
        return super.getStatisticCount() + 1;
    }

    @Override
    public Statistic getStatistic(int n) {
        if (n == super.getStatisticCount()) {
            return this.root.heightParameter;
        }
        return super.getStatistic(n);
    }

    @Override
    public Taxon getTaxon(int n) {
        return ((Node)this.getExternalNode((int)n)).taxon;
    }

    public Node getNodeOfParameter(Parameter parameter) {
        return this.parameterNodeMap.get(parameter);
    }

    public Parameter getRootHeightParameter() {
        return this.root.heightParameter;
    }

    public Parameter createNodeHeightsParameter(boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("At least one of rootNode, internalNodes or leafNodes must be true");
        }
        CompoundParameter compoundParameter = new CompoundParameter("nodeHeights(" + this.getId() + ")");
        for (n = this.externalNodeCount; n < this.nodeCount; ++n) {
            if ((!bl || this.nodes[n] != this.root) && (!bl2 || this.nodes[n] == this.root)) continue;
            compoundParameter.addParameter(this.nodes[n].heightParameter);
        }
        if (bl3) {
            for (n = 0; n < this.externalNodeCount; ++n) {
                compoundParameter.addParameter(this.nodes[n].heightParameter);
            }
        }
        return compoundParameter;
    }

    public Parameter getLeafHeightParameter(NodeRef nodeRef) {
        if (!this.isExternal(nodeRef)) {
            throw new RuntimeException("only leaves can be used with getLeafHeightParameter");
        }
        this.setTipDateSampled(true);
        return this.nodes[nodeRef.getNumber()].heightParameter;
    }

    public Parameter createNodeRatesParameter(double[] dArray, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("At least one of rootNode, internalNodes or leafNodes must be true");
        }
        CompoundParameter compoundParameter = new CompoundParameter("nodeRates(" + this.getId() + ")");
        this.hasRates = true;
        for (n = this.externalNodeCount; n < this.nodeCount; ++n) {
            this.nodes[n].createRateParameter(dArray);
            if ((!bl || this.nodes[n] != this.root) && (!bl2 || this.nodes[n] == this.root)) continue;
            compoundParameter.addParameter(this.nodes[n].rateParameter);
        }
        for (n = 0; n < this.externalNodeCount; ++n) {
            this.nodes[n].createRateParameter(dArray);
            if (!bl3) continue;
            compoundParameter.addParameter(this.nodes[n].rateParameter);
        }
        return compoundParameter;
    }

    public Parameter createNodeTraitsParameter(String string, double[] dArray) {
        return this.createNodeTraitsParameter(string, dArray.length, dArray, true, true, true, true);
    }

    public Parameter createNodeTraitsParameter(String string, int n, double[] dArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        this.checkValidFlags(bl, bl2, bl3);
        CompoundParameter compoundParameter = new CompoundParameter(string);
        this.hasTraits = true;
        for (n2 = this.externalNodeCount; n2 < this.nodeCount; ++n2) {
            this.nodes[n2].createTraitParameter(string, n, dArray, bl4);
            if ((!bl || this.nodes[n2] != this.root) && (!bl2 || this.nodes[n2] == this.root)) continue;
            compoundParameter.addParameter(this.nodes[n2].getTraitParameter(string));
        }
        for (n2 = 0; n2 < this.externalNodeCount; ++n2) {
            this.nodes[n2].createTraitParameter(string, n, dArray, bl4);
            if (!bl3) continue;
            compoundParameter.addParameter(this.nodes[n2].getTraitParameter(string));
        }
        return compoundParameter;
    }

    public Parameter createNodeTraitsParameterAsMatrix(String string, int n, double[] dArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n2;
        this.checkValidFlags(bl, bl2, bl3);
        int n3 = n;
        int n4 = (bl ? 1 : 0) + (bl2 ? this.internalNodeCount - 1 : 0) + (bl3 ? this.externalNodeCount : 0);
        FastMatrixParameter fastMatrixParameter = new FastMatrixParameter(string, n3, n4, 0.0, bl5);
        fastMatrixParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, n3 * n4));
        this.hasTraits = true;
        int n5 = 0;
        for (n2 = this.externalNodeCount; n2 < this.nodeCount; ++n2) {
            if ((!bl || this.nodes[n2] != this.root) && (!bl2 || this.nodes[n2] == this.root)) continue;
            this.nodes[n2].addTraitParameter(string, fastMatrixParameter.getParameter(n5), dArray, bl4);
            ++n5;
        }
        for (n2 = 0; n2 < this.externalNodeCount; ++n2) {
            if (!bl3) continue;
            this.nodes[n2].addTraitParameter(string, fastMatrixParameter.getParameter(n5), dArray, bl4);
            ++n5;
        }
        return fastMatrixParameter;
    }

    private void checkValidFlags(boolean bl, boolean bl2, boolean bl3) {
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("At least one of rootNode, internalNodes or leafNodes must be true");
        }
    }

    private void swapAllTraits(Node node, Node node2) {
        for (Map.Entry<String, Parameter> entry : node.traitParameters.entrySet()) {
            Parameter parameter = node.traitParameters.get(entry.getKey());
            Parameter parameter2 = node2.traitParameters.get(entry.getKey());
            int n = parameter.getDimension();
            for (int i = 0; i < n; ++i) {
                double d = parameter.getParameterValue(i);
                parameter.setParameterValue(i, parameter2.getParameterValue(i));
                parameter2.setParameterValue(i, d);
            }
            this.parameterNodeMap.put(parameter, node);
            this.parameterNodeMap.put(parameter2, node2);
        }
    }

    private void swapParameterObjects(Node node, Node node2) {
        Serializable serializable;
        double d = node.getHeight();
        double d2 = node2.getHeight();
        double d3 = 1.0;
        double d4 = 1.0;
        if (this.hasRates) {
            d3 = node.getRate();
            d4 = node2.getRate();
        }
        if (this.hasTraits) {
            serializable = new HashMap();
            HashMap<String, Parameter> hashMap = new HashMap<String, Parameter>();
            serializable.putAll(node.traitParameters);
            hashMap.putAll(node2.traitParameters);
            Map<String, Parameter> map = node.traitParameters;
            node.traitParameters = node2.traitParameters;
            node2.traitParameters = map;
            for (Parameter object : node.traitParameters.values()) {
                this.parameterNodeMap.put(object, node);
            }
            for (Parameter parameter : node2.traitParameters.values()) {
                this.parameterNodeMap.put(parameter, node2);
            }
            for (Map.Entry entry : serializable.entrySet()) {
                node.traitParameters.get(entry.getKey()).setParameterValueQuietly(0, ((Parameter)entry.getValue()).getParameterValue(0));
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                node2.traitParameters.get(entry.getKey()).setParameterValueQuietly(0, ((Parameter)entry.getValue()).getParameterValue(0));
            }
        }
        serializable = node.heightParameter;
        node.heightParameter = node2.heightParameter;
        node2.heightParameter = serializable;
        this.parameterNodeMap.put(node.heightParameter, node);
        this.parameterNodeMap.put(node2.heightParameter, node2);
        if (this.hasRates) {
            serializable = node.rateParameter;
            node.rateParameter = node2.rateParameter;
            node2.rateParameter = serializable;
            this.parameterNodeMap.put(node.rateParameter, node);
            this.parameterNodeMap.put(node2.rateParameter, node2);
        }
        node.heightParameter.setParameterValueQuietly(0, d);
        node2.heightParameter.setParameterValueQuietly(0, d2);
        if (this.hasRates) {
            node.rateParameter.setParameterValueQuietly(0, d3);
            node2.rateParameter.setParameterValueQuietly(0, d4);
        }
    }

    protected class Node
    implements NodeRef {
        public Node parent = null;
        public Node leftChild = null;
        public Node rightChild = null;
        private int number;
        public Parameter heightParameter;
        public Parameter rateParameter = null;
        public Taxon taxon = null;
        Map<String, Parameter> traitParameters = new HashMap<String, Parameter>();

        public Node() {
            this.heightParameter = null;
            this.number = 0;
            this.taxon = null;
        }

        public Node(Tree tree, NodeRef nodeRef) {
            this.heightParameter = new Parameter.Default(tree.getNodeHeight(nodeRef));
            DefaultTreeModel.this.addVariable(this.heightParameter);
            DefaultTreeModel.this.parameterNodeMap.put(this.heightParameter, this);
            this.number = nodeRef.getNumber();
            this.taxon = tree.getNodeTaxon(nodeRef);
            this.heightParameter.setId("" + this.number);
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                this.addChild(new Node(tree, tree.getChild(nodeRef, i)));
            }
        }

        public final void setupHeightBounds() {
            this.heightParameter.addBounds(new NodeHeightBounds(this.heightParameter));
        }

        public final void createRateParameter(double[] dArray) {
            if (this.rateParameter == null) {
                this.rateParameter = dArray != null ? new Parameter.Default(dArray[0]) : new Parameter.Default(1.0);
                this.setParameterId("rate", this.rateParameter);
                this.rateParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
                DefaultTreeModel.this.parameterNodeMap.put(this.rateParameter, this);
                DefaultTreeModel.this.addVariable(this.rateParameter);
            }
        }

        public final void addTraitParameter(String string, Parameter parameter, double[] dArray, boolean bl) {
            if (!this.traitParameters.containsKey(string)) {
                this.setParameterId(string, parameter);
                this.setParameterValues(parameter, parameter.getDimension(), dArray);
                this.traitParameters.put(string, parameter);
                if (bl) {
                    DefaultTreeModel.this.addVariable(parameter);
                }
            }
        }

        private void setParameterValues(Parameter parameter, int n, double[] dArray) {
            if (dArray != null && dArray.length > 0) {
                for (int i = 0; i < n; ++i) {
                    if (dArray.length == n) {
                        parameter.setParameterValue(i, dArray[i]);
                        continue;
                    }
                    parameter.setParameterValue(i, dArray[0]);
                }
            }
        }

        public final void createTraitParameter(String string, int n, double[] dArray, boolean bl) {
            if (!this.traitParameters.containsKey(string)) {
                Parameter.Default default_ = new Parameter.Default(n);
                this.setParameterId(string, default_);
                default_.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, n));
                this.setParameterValues(default_, n, dArray);
                this.traitParameters.put(string, default_);
                DefaultTreeModel.this.parameterNodeMap.put(default_, this);
                if (bl) {
                    DefaultTreeModel.this.addVariable(default_);
                }
            }
        }

        private void setParameterId(String string, Parameter parameter) {
            if (this.isRoot()) {
                parameter.setId("root." + string);
            } else if (this.isExternal()) {
                parameter.setId(DefaultTreeModel.this.getTaxonId(this.getNumber()) + "." + string);
            } else {
                parameter.setId("node" + this.getNumber() + "." + string);
            }
        }

        public final Parameter getHeightParameter() {
            return this.heightParameter;
        }

        public final double getHeight() {
            return this.heightParameter.getParameterValue(0);
        }

        public final double getRate() {
            return this.rateParameter.getParameterValue(0);
        }

        public final double getTrait(String string) {
            return this.traitParameters.get(string).getParameterValue(0);
        }

        public final double[] getMultivariateTrait(String string) {
            return this.traitParameters.get(string).getParameterValues();
        }

        public final Map<String, Parameter> getTraitMap() {
            return this.traitParameters;
        }

        public final void setHeight(double d) {
            this.heightParameter.setParameterValue(0, d);
        }

        public final void setHeightQuietly(double d) {
            this.heightParameter.setParameterValueQuietly(0, d);
        }

        public final void setRate(double d) {
            this.rateParameter.setParameterValue(0, d);
        }

        public final void setTrait(String string, double d) {
            this.traitParameters.get(string).setParameterValue(0, d);
        }

        public final void setMultivariateTrait(String string, double[] dArray) {
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                this.traitParameters.get(string).setParameterValue(i, dArray[i]);
            }
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public void setNumber(int n) {
            this.number = n;
        }

        public final int getChildCount() {
            int n = 0;
            if (this.leftChild != null) {
                ++n;
            }
            if (this.rightChild != null) {
                ++n;
            }
            return n;
        }

        public Node getChild(int n) {
            if (n == 0) {
                return this.leftChild;
            }
            if (n == 1) {
                return this.rightChild;
            }
            throw new IllegalArgumentException("TreeModel.Nodes can only have 2 children");
        }

        public boolean hasChild(Node node) {
            return this.leftChild == node || this.rightChild == node;
        }

        public void addChild(Node node) {
            if (this.leftChild == null) {
                this.leftChild = node;
            } else if (this.rightChild == null) {
                this.rightChild = node;
            } else {
                throw new IllegalArgumentException("TreeModel.Nodes can only have 2 children");
            }
            node.parent = this;
        }

        public Node removeChild(Node node) {
            if (this.leftChild == node) {
                this.leftChild = null;
            } else if (this.rightChild == node) {
                this.rightChild = null;
            } else {
                throw new IllegalArgumentException("Unknown child node");
            }
            node.parent = null;
            return node;
        }

        public Node removeChild(int n) {
            Node node;
            if (n == 0) {
                node = this.leftChild;
                this.leftChild = null;
            } else if (n == 1) {
                node = this.rightChild;
                this.rightChild = null;
            } else {
                throw new IllegalArgumentException("TreeModel.Nodes can only have 2 children");
            }
            node.parent = null;
            return node;
        }

        public boolean hasNoChildren() {
            return this.leftChild == null && this.rightChild == null;
        }

        public boolean isExternal() {
            return this.hasNoChildren();
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public String toString() {
            return "node " + this.number + ", height=" + this.getHeight() + (this.taxon != null ? ": " + this.taxon.getId() : "");
        }

        public Parameter getTraitParameter(String string) {
            return this.traitParameters.get(string);
        }
    }

    private class NodeHeightBounds
    implements Bounds<Double> {
        private Parameter nodeHeightParameter = null;

        public NodeHeightBounds(Parameter parameter) {
            this.nodeHeightParameter = parameter;
        }

        @Override
        public Double getUpperLimit(int n) {
            Node node = DefaultTreeModel.this.getNodeOfParameter(this.nodeHeightParameter);
            if (node.isRoot()) {
                return Double.POSITIVE_INFINITY;
            }
            return node.parent.getHeight();
        }

        @Override
        public Double getLowerLimit(int n) {
            Node node = DefaultTreeModel.this.getNodeOfParameter(this.nodeHeightParameter);
            if (node.isExternal()) {
                return 0.0;
            }
            return Math.max(node.leftChild.getHeight(), node.rightChild.getHeight());
        }

        @Override
        public int getBoundsDimension() {
            return 1;
        }
    }
}

