/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;

public class UniformNodeHeightOperator
extends AbstractTreeOperator {
    private final TreeModel tree;

    public UniformNodeHeightOperator(TreeModel treeModel, double d) {
        this.tree = treeModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        NodeRef nodeRef;
        NodeRef nodeRef2 = this.tree.getRoot();
        while ((nodeRef = this.tree.getInternalNode(MathUtils.nextInt(this.tree.getInternalNodeCount()))) == nodeRef2) {
        }
        double d = this.tree.getNodeHeight(this.tree.getParent(nodeRef));
        double d2 = Math.max(this.tree.getNodeHeight(this.tree.getChild(nodeRef, 0)), this.tree.getNodeHeight(this.tree.getChild(nodeRef, 1)));
        double d3 = this.tree.getNodeHeight(nodeRef);
        return this.doUniform(nodeRef, d3, d, d2);
    }

    private double doUniform(NodeRef nodeRef, double d, double d2, double d3) {
        this.tree.setNodeHeight(nodeRef, MathUtils.nextDouble() * (d2 - d3) + d3);
        return 0.0;
    }

    @Override
    public String getOperatorName() {
        return "uniform(" + this.tree.getId() + " internal nodes)";
    }
}

