/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.branchratemodel.CountableBranchCategoryProvider;
import dr.evomodel.tree.TreeModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.List;

public class CountableMixtureBranchRates
extends AbstractBranchRateModel
implements Loggable {
    private final Parameter ratesParameter;
    private final TreeModel treeModel;
    private final List<AbstractBranchRateModel> randomEffectsModels;
    private final int categoryCount;
    private final Parameter timeCoefficient;
    private final TimeDependentModel timeDependentModel;
    private final TreeTraitProvider.Helper helper = new TreeTraitProvider.Helper();
    private final CountableBranchCategoryProvider rateCategories;
    private final boolean modelInLogSpace;

    public CountableMixtureBranchRates(CountableBranchCategoryProvider countableBranchCategoryProvider, TreeModel treeModel, Parameter parameter, Parameter parameter2, List<AbstractBranchRateModel> list, boolean bl) {
        super("countableMixtureBranchRates");
        this.treeModel = treeModel;
        this.categoryCount = parameter.getDimension();
        this.rateCategories = countableBranchCategoryProvider;
        countableBranchCategoryProvider.setCategoryCount(this.categoryCount);
        if (countableBranchCategoryProvider instanceof Model) {
            this.addModel((Model)((Object)countableBranchCategoryProvider));
        }
        this.ratesParameter = parameter;
        this.addVariable(parameter);
        this.timeCoefficient = parameter2;
        if (parameter2 != null) {
            this.addVariable(parameter2);
        }
        this.randomEffectsModels = list;
        if (this.randomEffectsModels != null) {
            for (AbstractBranchRateModel abstractBranchRateModel : this.randomEffectsModels) {
                this.addModel(abstractBranchRateModel);
            }
        }
        this.timeDependentModel = new TimeDependentModel.Average();
        this.modelInLogSpace = bl;
        this.helper.addTrait(this);
        this.helper.addTrait(new TreeTrait.I(){

            @Override
            public String getTraitName() {
                return CountableMixtureBranchRates.this.getCategoryTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Integer getTrait(Tree tree, NodeRef nodeRef) {
                return CountableMixtureBranchRates.this.getBranchCategory(tree, nodeRef);
            }
        });
        this.helper.addTrait(new TreeTrait.D(){

            @Override
            public String getTraitName() {
                return CountableMixtureBranchRates.this.getCategoryEffectTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Double getTrait(Tree tree, NodeRef nodeRef) {
                return CountableMixtureBranchRates.this.getBranchCategoryEffect(tree, nodeRef);
            }
        });
        this.helper.addTrait(new TreeTrait.D(){

            @Override
            public String getTraitName() {
                return CountableMixtureBranchRates.this.getCategoryRateTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Double getTrait(Tree tree, NodeRef nodeRef) {
                return CountableMixtureBranchRates.this.getBranchCategoryRate(tree, nodeRef);
            }
        });
        this.helper.addTrait(new TreeTrait.D(){

            @Override
            public String getTraitName() {
                return CountableMixtureBranchRates.this.getRandomEffectTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Double getTrait(Tree tree, NodeRef nodeRef) {
                return CountableMixtureBranchRates.this.getBranchRandomEffect(tree, nodeRef);
            }
        });
        this.helper.addTrait(new TreeTrait.D(){

            @Override
            public String getTraitName() {
                return CountableMixtureBranchRates.this.getBranchTimeEffectTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Double getTrait(Tree tree, NodeRef nodeRef) {
                return CountableMixtureBranchRates.this.getBranchTimeEffect(tree, nodeRef);
            }
        });
    }

    private String getCategoryTraitName() {
        return this.getTraitName() + ".category";
    }

    private String getCategoryEffectTraitName() {
        return this.getTraitName() + ".category.effect";
    }

    private String getCategoryRateTraitName() {
        return this.getTraitName() + ".category.rate";
    }

    private String getRandomEffectTraitName() {
        return this.getTraitName() + ".random.effect";
    }

    private int getBranchCategory(Tree tree, NodeRef nodeRef) {
        return this.rateCategories.getBranchCategory(tree, nodeRef);
    }

    private String getBranchTimeEffectTraitName() {
        return this.getTraitName() + ".time.effect";
    }

    private double getBranchCategoryRate(Tree tree, NodeRef nodeRef) {
        if (this.modelInLogSpace) {
            return this.ratesParameter.getParameterValue(this.getBranchCategory(tree, nodeRef));
        }
        return Math.exp(this.ratesParameter.getParameterValue(this.getBranchCategory(tree, nodeRef)));
    }

    private double getBranchCategoryEffect(Tree tree, NodeRef nodeRef) {
        if (this.modelInLogSpace) {
            return this.getBranchCategoryRate(tree, nodeRef) - this.ratesParameter.getParameterValue(0);
        }
        return this.getBranchCategoryRate(tree, nodeRef) / this.ratesParameter.getParameterValue(0);
    }

    private double getBranchRandomEffect(Tree tree, NodeRef nodeRef) {
        double d = this.modelInLogSpace ? 0.0 : 1.0;
        if (this.randomEffectsModels != null) {
            for (AbstractBranchRateModel abstractBranchRateModel : this.randomEffectsModels) {
                if (this.modelInLogSpace) {
                    d += abstractBranchRateModel.getBranchRate(tree, nodeRef);
                    continue;
                }
                d *= abstractBranchRateModel.getBranchRate(tree, nodeRef);
            }
        }
        return d;
    }

    private double getBranchTimeEffect(Tree tree, NodeRef nodeRef) {
        if (this.timeCoefficient != null) {
            int n = this.rateCategories.getBranchCategory(tree, nodeRef);
            double d = this.timeCoefficient.getParameterValue(n);
            if (this.modelInLogSpace) {
                return d * this.timeDependentModel.getMidpointValue(tree, nodeRef, true);
            }
            return Math.pow(this.timeDependentModel.getMidpointValue(tree, nodeRef, false), d);
        }
        if (this.modelInLogSpace) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.helper.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.helper.getTreeTrait(string);
    }

    @Override
    public double getLogLikelihood() {
        double d = 0.0;
        if (this.randomEffectsModels != null) {
            for (AbstractBranchRateModel abstractBranchRateModel : this.randomEffectsModels) {
                d += abstractBranchRateModel.getLogLikelihood();
            }
        }
        return d;
    }

    void test() {
        this.getTrait(null, null);
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.ratesParameter.getDimension()];
        for (int i = 0; i < this.ratesParameter.getDimension(); ++i) {
            logColumnArray[i] = new OccupancyColumn(i);
        }
        return logColumnArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.rateCategories) {
            this.fireModelChanged();
            return;
        } else {
            AbstractBranchRateModel abstractBranchRateModel = this.findRandomEffectsModel(model);
            if (abstractBranchRateModel == null) throw new IllegalArgumentException("Unknown model component!");
            if (object == model) {
                this.fireModelChanged();
                return;
            } else {
                if (object != null) throw new IllegalArgumentException("Unknown object component!");
                this.fireModelChanged(null, n);
            }
        }
    }

    private AbstractBranchRateModel findRandomEffectsModel(Model model) {
        AbstractBranchRateModel abstractBranchRateModel = null;
        int n = this.randomEffectsModels.indexOf(model);
        if (n != -1) {
            abstractBranchRateModel = this.randomEffectsModels.get(n);
        }
        return abstractBranchRateModel;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (!tree.isRoot(nodeRef)) : "root node doesn't have a rate!";
        int n = this.rateCategories.getBranchCategory(tree, nodeRef);
        double d = this.ratesParameter.getParameterValue(n);
        double d2 = 0.0;
        if (this.timeCoefficient != null) {
            d2 = this.timeCoefficient.getParameterValue(n);
        }
        if (this.timeCoefficient != null) {
            d = this.modelInLogSpace ? (d += d2 * this.timeDependentModel.getMidpointValue(tree, nodeRef, true)) : (d *= Math.pow(this.timeDependentModel.getMidpointValue(tree, nodeRef, false), d2));
        }
        if (this.randomEffectsModels != null) {
            for (AbstractBranchRateModel abstractBranchRateModel : this.randomEffectsModels) {
                if (this.modelInLogSpace) {
                    d += abstractBranchRateModel.getBranchRate(tree, nodeRef);
                    continue;
                }
                d *= abstractBranchRateModel.getBranchRate(tree, nodeRef);
            }
        }
        if (this.modelInLogSpace) {
            d = Math.exp(d);
        }
        return d;
    }

    public static interface TimeDependentModel {
        public double getMidpointValue(Tree var1, NodeRef var2, boolean var3);

        public static class Average
        implements TimeDependentModel {
            @Override
            public double getMidpointValue(Tree tree, NodeRef nodeRef, boolean bl) {
                double d = tree.getNodeHeight(nodeRef);
                double d2 = tree.getNodeHeight(tree.getParent(nodeRef));
                double d3 = (d + d2) / 2.0;
                if (bl) {
                    return Math.log(d3);
                }
                return d3;
            }
        }
    }

    private class OccupancyColumn
    extends NumberColumn {
        private final int index;

        public OccupancyColumn(int n) {
            super("Occupancy");
            this.index = n;
        }

        @Override
        public double getDoubleValue() {
            int n = 0;
            for (NodeRef nodeRef : CountableMixtureBranchRates.this.treeModel.getNodes()) {
                if (nodeRef == CountableMixtureBranchRates.this.treeModel.getRoot() || CountableMixtureBranchRates.this.rateCategories.getBranchCategory(CountableMixtureBranchRates.this.treeModel, nodeRef) != this.index) continue;
                ++n;
            }
            return n;
        }
    }
}

