/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;

@Deprecated
public class OldHiddenNucleotides
extends DataType {
    public static final String DESCRIPTION = "hiddenNucleotide";
    public static final OldHiddenNucleotides INSTANCE = new OldHiddenNucleotides(2);
    private int hiddenClassCount;

    public OldHiddenNucleotides(int n) {
        this.hiddenClassCount = n;
        this.stateCount = 4 * this.hiddenClassCount;
        this.ambiguousStateCount = this.stateCount + 6;
    }

    @Override
    public char[] getValidChars() {
        return null;
    }

    @Override
    public int getState(char c) {
        switch (c) {
            case 'A': 
            case 'a': {
                return this.stateCount;
            }
            case 'C': 
            case 'c': {
                return this.stateCount + 1;
            }
            case 'G': 
            case 'g': {
                return this.stateCount + 2;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return this.stateCount + 3;
            }
            case '-': 
            case '?': {
                return this.getGapState();
            }
        }
        int n = c - 48;
        if (c > '?') {
            --n;
        }
        if (c > 'A') {
            --n;
        }
        if (c > 'C') {
            --n;
        }
        if (c > 'G') {
            --n;
        }
        if (c > 'T') {
            --n;
        }
        if (c > 'U') {
            --n;
        }
        if (c > 'a') {
            --n;
        }
        if (c > 'g') {
            --n;
        }
        if (c > 'c') {
            --n;
        }
        if (c > 't') {
            --n;
        }
        if (c > 'u') {
            --n;
        }
        return n;
    }

    @Override
    public char getChar(int n) {
        if (n >= this.stateCount) {
            switch (n - this.stateCount) {
                case 0: {
                    return 'A';
                }
                case 1: {
                    return 'C';
                }
                case 2: {
                    return 'G';
                }
                case 3: {
                    return 'T';
                }
            }
            return '-';
        }
        char c = (char)(n + 48);
        if (c >= '?') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'A') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'C') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'G') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'T') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'U') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'a') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'g') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'c') {
            c = (char)(c + '\u0001');
        }
        if (c >= 't') {
            c = (char)(c + '\u0001');
        }
        if (c >= 'u') {
            c = (char)(c + '\u0001');
        }
        return c;
    }

    @Override
    public int[] getStates(int n) {
        if (n >= this.stateCount && n <= this.stateCount + 3) {
            int[] nArray = new int[this.hiddenClassCount];
            for (int i = 0; i < this.hiddenClassCount; ++i) {
                nArray[i] = n % 4 + i * 4;
            }
            return nArray;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean[] getStateSet(int n) {
        int n2;
        boolean[] blArray = new boolean[this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            blArray[n2] = false;
        }
        if (!this.isAmbiguousState(n)) {
            blArray[n] = true;
        } else if (n < this.stateCount + 4) {
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                if (n2 % 4 != n % 4) continue;
                blArray[n2] = true;
            }
        } else {
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                blArray[n2] = true;
            }
        }
        return blArray;
    }

    @Override
    public int getUnknownState() {
        return this.stateCount + 4;
    }

    @Override
    public int getGapState() {
        return this.stateCount + 5;
    }

    @Override
    public boolean isAmbiguousChar(char c) {
        return this.isAmbiguousState(this.getState(c));
    }

    @Override
    public boolean isUnknownChar(char c) {
        return this.isUnknownState(this.getState(c));
    }

    @Override
    public boolean isGapChar(char c) {
        return this.isGapState(this.getState(c));
    }

    @Override
    public boolean isAmbiguousState(int n) {
        return n >= this.stateCount;
    }

    @Override
    public boolean isUnknownState(int n) {
        return n == this.getUnknownState();
    }

    @Override
    public boolean isGapState(int n) {
        return n == this.getGapState();
    }

    @Override
    public int getType() {
        return 999;
    }

    @Override
    public String getDescription() {
        return "Hidden-state Nucleotides";
    }

    public int getHiddenClassCount() {
        return this.hiddenClassCount;
    }
}

