% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart_cholesky.R
\name{bi.dist.wishart_cholesky}
\alias{bi.dist.wishart_cholesky}
\title{Wishart Cholesky Distribution}
\usage{
bi.dist.wishart_cholesky(
  concentration,
  scale_matrix = py_none(),
  rate_matrix = py_none(),
  scale_tril = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{concentration}{(numeric or vector) Positive concentration parameter analogous to the
concentration of a `Gamma` distribution. The concentration must be larger
than the dimensionality of the scale matrix.}

\item{scale_matrix}{(numeric vector, matrix, or array, optional) Scale matrix analogous to the inverse rate of a `Gamma`
distribution. If not provided, `rate_matrix` or `scale_tril` must be.}

\item{rate_matrix}{(numeric vector, matrix, or array, optional) Rate matrix anaologous to the rate of a `Gamma`
distribution. If not provided, `scale_matrix` or `scale_tril` must be.}

\item{scale_tril}{(numeric vector, matrix, or array, optional) Cholesky decomposition of the `scale_matrix`.
If not provided, `scale_matrix` or `rate_matrix` must be.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean vector to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector.  This is used with `.expand(shape)` when `sample=False` (model building) to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Wishart Cholesky  distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Wishart Cholesky  distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
* The **Wishart** distribution is a distribution over positive definite matrices,
often used as a prior for covariance or precision matrices in multivariate normal models.
* The **Cholesky parameterization** of the Wishart (called "wishart_cholesky" in Stan, for example)
reparameterizes the Wishart over its **lower (or upper) triangular Cholesky factor**. This is useful for numerical
stability and unconstrained parameterization in Bayesian sampling frameworks.
* In this parameterization, one works with a lower-triangular matrix $L_W$ such that
\deqn{
  \Sigma = L_W L_W^\top
}
and imposes a density over $L_W$ corresponding to the induced Wishart density on \deqn{\Sigma}.

The Wishart distribution is a multivariate distribution used as a prior distribution
for covariance matrices. This implementation represents the distribution in terms
of its Cholesky decomposition.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.wishart_cholesky(
concentration = 5,
scale_matrix = matrix(c(1,0,0,1),
nrow = 2),
sample = TRUE)
}
}
