% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_sided_truncated_distribution.R
\name{bi.dist.two_sided_truncated_distribution}
\alias{bi.dist.two_sided_truncated_distribution}
\title{Two-Sided Truncated Distribution}
\usage{
bi.dist.two_sided_truncated_distribution(
  base_dist,
  low = 0,
  high = 1,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{base_dist}{The base distribution to truncate.}

\item{low}{The lower bound for truncation.}

\item{high}{The upper bound for truncation.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector. When `sample=False` (model building), this is used with `.expand(shape)` to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{Integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{Logical; if `TRUE`, returns the raw BI distribution object. Defaults to `FALSE`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Two-Sided Truncated distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Two-Sided Truncated distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
A "two-sided truncated distribution" is a general concept: you take a base continuous distribution
and **restrict it** to an interval ([`low`, `high`]), discarding all mass outside, then **renormalize**
 so the inner portion integrates to 1. I'll spell out the general formulas, caveats, sampling strategies,
 and special cases (e.g. truncated normal) to illustrate.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.two_sided_truncated_distribution(
base_dist = bi.dist.normal(0,1, create_obj = TRUE),
high = 0.5, low = 0.1, sample = TRUE)
}
}
\seealso{
\url{https://num.pyro.ai/en/stable/distributions.html#twosidedtruncateddistribution}
}
