% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.binom.test.R
\name{power.binom.test}
\alias{power.binom.test}
\title{Power Calculation for the Exact Binomial Test}
\usage{
power.binom.test(
  n = 20,
  p = 0.5,
  p0 = 0.3,
  alpha = 0.05,
  alternative = c("two.sided", "greater", "less"),
  nsim = 1e+05,
  seed = 2025
)
}
\arguments{
\item{n}{Sample size of the experimental group.}

\item{p}{Assumed true proportion (response rate) of the experimental treatment.}

\item{p0}{Historical proportion (null hypothesis) used as a benchmark.}

\item{alpha}{Type I error rate (significance level).}

\item{alternative}{Character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less".}

\item{nsim}{Number of simulated trials; defaults to 100,000 for high precision.}

\item{seed}{Seed for reproducibility.}
}
\value{
A numeric value representing the statistical power.
}
\description{
Calculates the power of a one-sample exact binomial test via simulation.
This is used to compare a treatment response rate against a fixed
historical benchmark.
}
\examples{
\donttest{
power.binom.test(n=110, p=0.4, p0=0.128)
}

}
