% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.findTheta}
\alias{.findTheta}
\title{Perform the EM algorithm of the Bayesian GLM fitting}
\usage{
.findTheta(theta, spde, y, X, QK, Psi, A, Ns, tol, verbose = FALSE)
}
\arguments{
\item{theta}{the vector of initial values for theta}

\item{spde}{a list containing the sparse matrix elements Cmat, Gmat, and GtCinvG}

\item{y}{the vector of response values}

\item{X}{the sparse matrix of the data values}

\item{QK}{a sparse matrix of the prior precision found using the initial values of the hyperparameters}

\item{Psi}{a sparse matrix representation of the basis function mapping the data locations to the mesh vertices}

\item{A}{a precomputed matrix crossprod(X\%*\%Psi)}

\item{Ns}{the number of columns for the random matrix used in the Hutchinson estimator}

\item{tol}{a value for the tolerance used for a stopping rule (compared to
the squared norm of the differences between \code{theta(s)} and \code{theta(s-1)})}

\item{verbose}{(logical) Should intermediate output be displayed?}
}
\description{
Perform the EM algorithm of the Bayesian GLM fitting
}
