% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activations.posterior}
\alias{activations.posterior}
\title{Identify activations using joint posterior probabilities}
\usage{
activations.posterior(x, fields, session, alpha = 0.05, gamma)
}
\arguments{
\item{x}{Result of \code{BayesGLM}, of class \code{"BGLM"}.}

\item{fields, session, alpha, gamma}{See \code{\link{activations}}.}
}
\value{
A list with two elements: \code{active}, which gives a matrix of zeros
and ones of the same dimension as \code{x$field_estimates${session}},
and \code{excur_result}, an object of class \code{"excurobj"} (see INLA's \code{excursions.inla} for
more information).
}
\description{
Identifies areas of activation given an activation threshold and significance
level using joint posterior probabilities
}
\details{
For a given latent field, identifies locations that exceed a certain activation
threshold (e.g. 1 percent signal change) at a given significance level, based on the joint
posterior distribution of the latent field.
}
\keyword{internal}
