% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.f.test}
\alias{BFpower.f.test}
\title{Sample Size Determination for the Bayesian F-test}
\usage{
BFpower.f.test(
  threshold,
  true_rate,
  false_rate,
  p,
  k,
  prior_analysis,
  dff,
  rscale,
  f_m,
  prior_design = NULL,
  dff_d,
  rscale_d,
  f_m_d,
  N = NULL,
  type_rate = "positive",
  ROPE = NULL,
  plot_power = FALSE,
  plot_rel = FALSE
)
}
\arguments{
\item{threshold}{Numeric scalar. Threshold for compelling evidence (must be > 1).}

\item{true_rate}{Numeric scalar. Targeted true positive or true negative rate (used only when
sample size determination is requested; \code{N = NULL}).}

\item{false_rate}{Numeric scalar. Targeted false positive or false negative rate (used only when
sample size determination is requested; \code{N = NULL}).}

\item{p}{Numeric integer. Number of predictors in the reduced model.}

\item{k}{Numeric integer. Number of predictors in the full model (must satisfy \code{k > p}).}

\item{prior_analysis}{Character. Analysis prior model under the alternative hypothesis:
\code{"effectsize"} or \code{"Moment"}.}

\item{dff}{Numeric scalar. Degrees of freedom for the analysis prior under the alternative
hypothesis. Must be a positive scalar, and must be at least 3 if
\code{prior_analysis = "Moment"}.}

\item{rscale}{Numeric scalar. Scale parameter for the analysis effect-size prior (only used when
\code{prior_analysis = "effectsize"}).}

\item{f_m}{Numeric scalar. Cohen's \eqn{f} effect-size parameter for the analysis prior (must be > 0).}

\item{prior_design}{Character. Design prior model under the alternative hypothesis:
\code{"effectsize"}, \code{"Moment"}, or \code{"Point"}.}

\item{dff_d}{Numeric scalar. Degrees of freedom for the design prior. Must be a positive scalar,
and at least 3 if \code{prior_design = "Moment"}.}

\item{rscale_d}{Numeric scalar. Scale parameter for the design effect-size prior
(only used when \code{prior_design = "effectsize"}).}

\item{f_m_d}{Numeric scalar. Cohen's \eqn{f} value for the design prior or the effect-size of the
point design prior.}

\item{N}{Numeric integer. Sample size. If \code{NULL}, sample size determination is performed.}

\item{type_rate}{Character. Either \code{"positive"} (control true/false positive rates) or
\code{"negative"} (control true/false negative rates).}

\item{ROPE}{Numeric vector. Numeric bounds for the interval null (only used when interval
Bayes factors are required).}

\item{plot_power}{Logical. Whether to plot power curves when
sample size determination is requested.}

\item{plot_rel}{Logical. Whether to plot the relationship between the BF and data.}
}
\value{
A list of class \code{BFpower_f} containing:
\describe{
\item{\code{type}}{Test type (always "Regression/ANOVA").}
\item{\code{k}, \code{p}}{Number of predictors in the full and reduced models.}
\item{\code{ROPE}}{Bounds for interval null (if used).}
\item{\code{analysis_h1}}{List containing the analysis prior specification, including the prior distribution, the scale \code{rscale}, f \code{f_m}, and degrees of freedom \code{dff}.}
\item{\code{design_h1}}{List containing the design prior specification, including the prior distribution, the scale \code{rscale}, f \code{f_m}, and degrees of freedom \code{dff} (or \code{NULL} if not specified).}
\item{\code{results}}{Data frame of probabilities of compelling/misleading evidence and the required or supplied sample size.}
\item{\code{threshold}}{Threshold of compelling evidence.}
\item{\code{plot_power}}{Logical; whether power curves are plotted.}
\item{\code{plot_rel}}{Logical; whether the relationship between the Bayes factor and data is plotted.}
}
If sample size determination fails, the function returns \code{NaN} and prints a message.
}
\description{
This function performs sample size determination (when \code{N = NULL}) or
calculates the probability of compelling/misleading evidence for a fixed sample
size.
}
\details{
Computes required sample size or probabilities of compelling or misleading
evidence for a fixed sample size.

\strong{1. Sample size determination mode (when \code{N = NULL}):}

If no sample size is provided, the function calculates the minimum sample size to achieve the desired configuration below. The user must provide:
\itemize{
\item \code{type_rate} - either \code{"positive"} to control true/false positive rates, or \code{"negative"} to control true/false negative rates.
\item \code{true_rate} - the targeted true positive or true negative rate (between 0.6 and 0.999).
\item \code{false_rate} - the acceptable false positive or false negative rate (between 0.001 and 0.1).
\item \code{threshold} - the Bayes factor threshold for compelling evidence (must be > 1).
}

The function iteratively finds the smallest sample size for which the probability of obtaining compelling evidence meets or exceeds \code{true_rate}, while the probability of misleading evidence does not exceed \code{false_rate}.

\strong{2. Fixed-sample analysis mode (when \code{N} is supplied):}

If a positive numeric sample size \code{N} is provided, the function computes the probabilities of obtaining compelling or misleading evidence for that fixed sample size. In this mode, the arguments \code{type_rate}, \code{true_rate}, and \code{false_rate} are ignored; only the Bayes factor threshold \code{threshold} is used.

\strong{Model specification:}

The function requires the user to specify the full model (\code{k} predictors) and the reduced model (\code{p} predictors, \code{k > p}), and the analysis prior under the alternative hypothesis. Depending on the chosen \code{prior_analysis}, different arguments are required:
\itemize{
\item \code{prior_analysis = "effectsize"}: requires \code{rscale} (scale parameter) and \code{f_m} (Cohen's f effect-size), and \code{dff} (degrees of freedom).
\item \code{prior_analysis = "Moment"}: requires \code{f_m} (Cohen's f effect-size) and \code{dff} (degrees of freedom, must be >= 3); \code{rscale} is not used.
}
The design prior under the alternative hypothesis can optionally be specified using \code{prior_design}, which can be:
\itemize{
\item \code{"effectsize"}: requires \code{rscale_d}, \code{f_m_d}, and \code{dff_d}.
\item \code{"Moment"}: requires \code{f_m_d} and \code{dff_d} (>=3); \code{rscale_d} is not used.
\item \code{"Point"}: requires \code{f_m_d} only; \code{rscale_d} and \code{dff_d} are not used.
}

\strong{interval null Hypothesis:}

If \code{ROPE} is provided, the function evaluates the Bayes factor for an interval null. Otherwise, a point-null hypothesis is assumed.

\strong{Plotting:}

If \code{plot_power = TRUE}, the function plots the probability of compelling evidence as a function of sample size. If \code{plot_rel = TRUE}, the relationship between the Bayes factor and Cohen's \code{f} is plotted.
}
\examples{
BFpower.f.test(
 threshold = 3,
 true_rate = 0.8,
 false_rate = 0.05,
 p = 3,
 k = 4,
 prior_analysis = "effectsize",
 dff = 3,
 rscale = 0.18,
 f_m = 0.1,
 prior_design = "Point",
 f_m_d = 0.1,
 plot_power = TRUE,
 plot_rel = TRUE)

}
