% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rates_fn.R
\name{plot_rates_fn}
\alias{plot_rates_fn}
\title{A function to plot the fitted mortality rates, accompanied by credible intervals, from posterior samples generated for stochastic mortality models}
\usage{
plot_rates_fn(
  result,
  pred_int = 0.95,
  plot_type = "age",
  plot_ages = NULL,
  plot_years = NULL,
  legends = TRUE
)
}
\arguments{
\item{result}{object of type either "fit_result" or "BayesMoFo".}

\item{pred_int}{A numeric value (between 0 and 1) specifying the credible level of uncertainty bands. Default is \code{pred_int=0.95} (\eqn{95\%} intervals).}

\item{plot_type}{A character string (\code{c("age","time")}) to indicate whether to plot by age (default) or by time/year.}

\item{plot_ages}{A numeric vector specifying which range of ages to plot for visualisation. If not specified, use whatever ages that were used to fit the model (i.e. \code{fit_result$death$ages}). One panel will be constructed per age when \code{plot_type="time"}, with a maximum of nine panels. If exceeded, only the first nine ages will be plotted.}

\item{plot_years}{A numeric vector specifying which range of years to plot for visualisation. If not specified, use whatever years that were used to fit the model (i.e. \code{fit_result$death$years}). One panel will be constructed per year when \code{plot_type="age"}, with a maximum of nine panels. If exceeded, only the first nine years will be plotted.}

\item{legends}{A logical value to indicate if legends of the plots should be shown (default) or suppressed (e.g. to aid visibility).}
}
\value{
A plot illustrating the median fitted and forecast mortality rates, accompanied by credible intervals.
}
\description{
Plot the fitted mortality rates, accompanied by credible intervals (user-specified level), using posterior samples stored in "fit_result" object.
}
\examples{
\donttest{
#load and prepare data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#fit any mortality model
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,models="APCI",n_iter=1000,forecast=TRUE)

#default plot
plot_rates_fn(runBayesMoFo_result)

#plot by age and changing pre-specified arguments 
plot_rates_fn(runBayesMoFo_result,pred_int=0.8,plot_ages=40:60,plot_years=c(2017,2020))

#plot by time/year
plot_rates_fn(runBayesMoFo_result,plot_type="time",plot_ages=c(40,50,60))
}
}
\concept{credible intervals}
\concept{fitted death rates}
\concept{forecast death rates}
\keyword{graphics}
\keyword{plots}
\keyword{visualization}
