% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_summarised.R
\docType{data}
\name{data_summarised}
\alias{data_summarised}
\title{Sample mortality data stratified by insurance products}
\format{
A data frame with 1278 rows of observations and 9 variables:
\describe{
\item{Product}{Character. The name of the insurance product associated with the observation. There are in total 4 types of products considered in the dataset: \cr
\code{"ACI"}: ; \cr
\code{"DB"}: ; \cr
\code{"SCI"}: ; \cr
\code{"Annuities"}:  Note that this product contains a lot of missing values.}
\item{Age}{Numeric. The claim age \eqn{x} associated with the observation, ranging between 18-100.}
\item{Year}{Numeric. The claim year \eqn{t} associated with the observation, spanning years 2016-2020.}
\item{Exposure}{Numeric. The central exposure to risk, \eqn{E_x^c}, associated with the observation.}
\item{Claim}{Numeric. The number of claims ("deaths") associated with the observation.}
\item{ExpClaim}{Numeric. The expected number of claims associated with the observation.}
\item{Qx}{Numeric. The crude mortality rate associated with the observation. It can be computed as \eqn{\frac{\text{Claim}}{\text{Exposure}}}.}
\item{ExpQx}{Numeric. The expected crude mortality rate associated with the observation. It can be computed as \eqn{\frac{\text{ExpClaim}}{\text{Exposure}}}.}
\item{StdQx}{Numeric. The standard deviation of the crude mortality rate associated with the observation. It can be computed as \eqn{\sqrt{\frac{\text{Qx} (1-\text{Qx})}{\text{Exposure}}}}.}
}
}
\usage{
data("data_summarised")
}
\description{
This is a sample data set used for demonstration purposes.
}
\examples{
data("data_summarised")
str(data_summarised)
head(data_summarised)

#extracting a subset of the data (3 products)
data_summarised[data_summarised$Product==c("ACI","DB","SCI"),]

#extracting a subset of the data (ages 35-65)
data_summarised[(data_summarised$Age>=35 & data_summarised$Age<=65),]

}
\keyword{datasets}
