% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qnj.R
\name{qnj}
\alias{qnj}
\title{Mixing probability for getting assigned to an existing cluster}
\usage{
qnj(N, M, as, bs, Yn, alpha, cluster, Tl, K)
}
\arguments{
\item{N}{A scalar representing the number of data sequences}

\item{M}{A scalar representing the number of points available for each data sequence}

\item{as}{The hyperparameter value for the shape parameter in the inverse-gamma prior for the variance
component}

\item{bs}{The hyperparameter value for the scale parameter in the inverse-gamma prior for the variance
component}

\item{Yn}{A vector or matrix with data sequences for a cluster}

\item{alpha}{A list containing a vector for each cluster determining the constant level values
for each interval between change points in each cluster (or its initial values)}

\item{cluster}{A vector containing the cluster assignments for the data sequences (or its initial values)}

\item{Tl}{A list containing a vector for each cluster determining the change-point positions in each cluster
(or its initial values)}

\item{K}{A vector containing the number of change points for each cluster (or its initial values)}
}
\value{
A vector of same size as the vector `cluster` corresponding to the mixing term value used to compute the probability that the given data sequence `Yn` should be part of each existing cluster
}
\description{
Mixing probability for getting assigned to an existing cluster
}
\note{
This function is called within the Gibbs sampler. It should not be called alone.
}
\examples{
qnj(N = 5, M = 50, as = 2, bs = 1000, Yn = data[,1], alpha = c(10, 10),
 cluster = c(1,1,2,1,2), Tl = c(50,50), K = c(0,0))

}
\seealso{
[gibbs_alg()]
}
