% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postalphak.R
\name{postalphak}
\alias{postalphak}
\title{Full conditional for alphak}
\usage{
postalphak(M, Y, sigma2, K, Tl, cluster, clusteri)
}
\arguments{
\item{M}{A scalar representing the number of points available for each data sequence}

\item{Y}{A matrix M x N with the data sequences}

\item{sigma2}{A vector with the variances of the data sequences (or its initial values)}

\item{K}{A vector containing the number of change points for each cluster (or its initial values)}

\item{Tl}{A list containing a vector for each cluster determining the change-point positions in each cluster
(or its initial values)}

\item{cluster}{A vector containing the cluster assignments for the data sequences (or its initial values)}

\item{clusteri}{A scalar with the index of a cluster}
}
\value{
A numerical vector of size `K` + 1 with sampled values from the full conditional of alphak for a given cluster `clusteri`
}
\description{
Full conditional for alphak
}
\note{
This function is called within the Gibbs sampler, but it can be called separately as well.
}
\examples{
data(data)
postalphak(M = 50, Y = data, sigma2 = 0.05, K = c(0, 0), Tl = c(50, 50),
 cluster = c(1,1,2,1,2), clusteri = 1)

}
\seealso{
[gibbs_alg()]
}
