% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/possigma2n.R
\name{possigma2n}
\alias{possigma2n}
\title{Full conditional function for sigma2}
\usage{
possigma2n(as, bs, M, Yn, k, Tln, alphan)
}
\arguments{
\item{as}{The hyperparameter value for the shape parameter in the inverse-gamma prior for the variance
component}

\item{bs}{The hyperparameter value for the scale parameter in the inverse-gamma prior for the variance
component}

\item{M}{A scalar representing the number of points available for each data sequence}

\item{Yn}{A vector or matrix with data sequences for a cluster}

\item{k}{A scalar for the number of changes points in a cluster}

\item{Tln}{A vector with the change-point positions for a cluster}

\item{alphan}{A vector with the constant level values for each interval between change points for a cluster}
}
\value{
A numerical value corresponding to a sampled value from the full conditional of the variance component
}
\description{
Full conditional function for sigma2
}
\note{
This function is called within the Gibbs sampler, but it can be used separately as well.
}
\examples{
data(data)
possigma2n(as = 2, bs = 1000, M = 50, Yn = data[,1], k = 0, Tln = 50, alphan = 15)

}
\seealso{
[gibbs_alg()]
}
