context("findExperiments")

test_that("findExperiments", {
  r = makeTestRegistry()
  p1 = addProblem(r, "one", 1)
  p2 = addProblem(r, "two", 2)
  a1 = addAlgorithm(r, "A", fun=function(static, dynamic) 1)
  a2 = addAlgorithm(r, "B", fun=function(static, dynamic) 1)
  addExperiments(r, list(makeDesign(p1), makeDesign(p2)), list(makeDesign(a1), makeDesign(a2)), repls=2)

  i = findExperiments(r)
  expect_equal(i, getJobIds(r)[1:8])
  i = findExperiments(r, 2:3)
  expect_equal(i, getJobIds(r)[2:3])
  i = findExperiments(r, prob.pattern="on")
  expect_equal(i, getJobIds(r)[1:4])
  i = findExperiments(r, algo.pattern="A")
  expect_equal(i, getJobIds(r)[c(1,2,5,6)])
  i = findExperiments(r, algo.pattern="foo")
  expect_equal(i, integer(0))
  i = findExperiments(r, repls=1)
  expect_equal(i, getJobIds(r)[seq(1,8,2)])
  i = findExperiments(r, ids = 1:4, repls=1)
  expect_equal(i, getJobIds(r)[c(1, 3)])
  i = findExperiments(r, prob.pattern="o", match.substring=FALSE)
  expect_equal(i, integer(0))
  i = findExperiments(r, prob.pattern="o", match.substring=TRUE)
  expect_equal(i, getJobIds(r)[1:8])
  i = findExperiments(r, prob.pattern="wo", match.substring=TRUE)
  expect_equal(i, getJobIds(r)[5:8])

  r = makeTestRegistry()
  p1 = addProblem(r, "one", 1)
  a3 = addAlgorithm(r, "A", fun=function(static, dynamic) 1)
  pd1 = makeDesign(p1, exhaustive=list(foo=1:3))
  addExperiments(r, pd1, makeDesign(a3))
  i = findExperiments(r, prob.pars=foo < 3)
  expect_equal(i, getJobIds(r)[1:2])
  a4 = addAlgorithm(r, "B", function(static, dynamic, bar) 1)
  ad4 = makeDesign(a4, exhaustive =list(bar=c("x", "y")))
  #o1 A, o1 Bx, o1 By, o2 A, o2 Bx, o2 By, o3 A, o3 Bx, o3 By
  addExperiments(r, pd1, ad4)
  i = findExperiments(r, algo.pattern="B", algo.pars=bar=="x")
  expect_equal(i, getJobIds(r)[c(4,6,8)])
  i = findExperiments(r, prob.pars=foo>2, algo.pattern="B", algo.pars=bar=="x")
  expect_equal(i, getJobIds(r)[8])
  i = findExperiments(r, prob.pars=foo>100)
  expect_equal(i, integer(0))
})

test_that("regexp works", {
  r = makeTestRegistry()
  p1 = addProblem(r, "one", 1)
  p2 = addProblem(r, "two", 1)
  a1 = addAlgorithm(r, "aab", fun=function(static, dynamic) 1)
  a2 = addAlgorithm(r, "aba", fun=function(static, dynamic) 1)
  a3 = addAlgorithm(r, "baa", fun=function(static, dynamic) 1)
  addExperiments(r, lapply(c(p1, p2), makeDesign), lapply(c(a1, a2, a3), makeDesign))

  ids = findExperiments(r, prob.pattern = "^o", regexp = TRUE)
  expect_equal(ids, 1:3)
  ids = findExperiments(r, prob.pattern = "o$", regexp = TRUE)
  expect_equal(ids, 4:6)
  ids = findExperiments(r, prob.pattern = "o$", algo.pattern = "aa", regexp = TRUE)
  expect_equal(ids, c(4, 6))
  ids = findExperiments(r, prob.pattern = "o$", algo.pattern = "ab", regexp = TRUE)
  expect_equal(ids, c(4, 5))
  ids = findExperiments(r, prob.pattern = "noooo", regexp = TRUE)
  expect_equal(ids, integer(0))

  ids = findExperiments(r, ids = 1:2, prob.pattern = "^o", regexp = TRUE)
  expect_equal(ids, c(1:2))
})
