% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaHZING_Model.R
\name{BaHZING_Model}
\alias{BaHZING_Model}
\title{BaHZING_Model Function
This function implements the BaHZING model for microbiome data analysis.}
\arguments{
\item{formatted_data}{An object containing formatted microbiome data.}

\item{x}{A vector of column names of the exposures.}

\item{covar}{An optional vector of the column names of covariates.}

\item{n.chains}{An optional integer specifying the number of parallel chains
for the model in jags.model function. Default is 3.}

\item{n.adapt}{An optional integer specifying the number of iterations for
adaptation in jags.model function. Default is 5000.}

\item{n.iter.burnin}{An optional integer specifying number of iterations in
update function. Default is 10000.}

\item{n.iter.sample}{An optional integer specifying the number of iterations
in coda.samples function. Default is 10000.}

\item{exposure_standardization}{Method for standardizing the exposures.
Should be one of "standard_normal" (the default), "quantile", or "none". If
"none", exposures are not standardized before analysis, and counterfactual
profiles must be specified by the user.}

\item{counterfactual_profiles}{A 2xP matrix or a vector with length of 2; P
is the number of exposures in x. If a 2xP matrix is provided,
the effect estimates for the mixture are interpreted as the estimated change
in the outcome when changing each exposure p in 1:P is changed from
\code{counterfactual_profiles[1,p]} to \code{counterfactual_profiles[2,p]}. If a vector of
length 2 is provided, the effect estimates for the mixture are interpreted as
the estimated change in the outcome when changing each exposure from
\code{counterfactual_profiles[1]} to \code{counterfactual_profiles[2]}. If
exposure_standardization = "standard_normal", then the default is c(-0.5, 0.5),
and the effect estimate is calculated based on increasing all exposures in
the mixture by one standard deviation. If exposure_standardization = "quantile",
then the default is c(0,1), and the effect estimate is calculated based on
increasing all exposures in the mixture by one quantile (where the number of
quantiles is based on the parameter q).}

\item{q}{An integer specifying the number of quantiles. Only required if
exposure_standardization = "quantile". If exposure_standardization =
"quantile" and q is not specified, then a default of q = 4 is used.}

\item{verbose}{If TRUE (default), function returns information a data quality
check.}

\item{return_all_estimates}{If FALSE (default), results do not include
the dispersion and omega estimates from the BaHZING model.}

\item{ROPE_range}{Region of practical equivalence (ROPE) for calculating
p_rope. Default is c(-0.1, 0.1).}
}
\value{
A data frame containing results of the Bayesian analysis, with the
following columns:
\itemize{
\item taxa_full: Full Taxa information, including all levels of the taxonomy.
Taxanomic levels are split by two underscores ('__').
\item taxa_name: Taxa name, which is the last level of the taxonomy.
\item domain: domain of the taxa.
\item exposure: Exposure name (either one of  the individual exposures, or the
mixture).
\item component: Zero inflated model estimate or the Count model estimate.
\item estimate: Point estimate of the posterior distributions.
\item bci_lcl: 95\% Bayesian Credible Interval Lower Limit. Calculated as the
equal tailed interval of posterior distributions using the quantiles method.
\item bci_ucl: 95\% Bayesian Credible Interval Upper Limit. Calculated as the
equal tailed interval of posterior distributions using the quantiles method.
\item p_direction: The Probability of Direction, calculated with \code{bayestestR}. A
higher value suggests a higher probability that the estimate is strictly
positive or negative. In other words, the closer the value to 1, the higher
the probability that the estimate is non-zero. Values can not be less than
50\%. From \code{bayestestR}: also known as the Maximum Probability of Effect
(MPE). This can be interpreted as the probability that a parameter (described
by its posterior distribution) is strictly positive or negative (whichever
is the most probable). Although differently expressed, this index is fairly
similar (i.e., is strongly correlated) to the frequentist p-value.
\item p_rope: The probability that the estimate is not within the Region of
practical equivalence (ROPE), calculated with \code{bayestestR}. The proportion
of the whole posterior distribution that doesn't lie within the \code{ROPE_range}.
\item p_map: Bayesian equivalent of the p-value, calculated with \code{bayestestR}.
From \code{bayestestR}:  p_map is related to the odds that a parameter (described
by its posterior distribution) has against the null hypothesis (h0) using
Mills' (2014, 2017) Objective Bayesian Hypothesis Testing framework. It
corresponds to the density value at the null (e.g., 0) divided by the
density at the Maximum A Posteriori (MAP).
}
}
\description{
BaHZING_Model Function
This function implements the BaHZING model for microbiome data analysis.
}
