% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coprimary_endpoint.R
\name{get_oc_coprimary}
\alias{get_oc_coprimary}
\title{Operating characteristics for for coprimary Endpoint}
\usage{
get_oc_coprimary(p1, p2, p3, p4, n, nsim, fb, sb, seed = NULL)
}
\arguments{
\item{p1}{Response rate (Response - PFS6)}

\item{p2}{Response rate (Response - no PFS6)}

\item{p3}{Response rate (No Response - PFS6)}

\item{p4}{Response rate (No Response - no PFS6)}

\item{n}{A numeric vector representing the additional patients enrolled at each interim analysis.
The value at index \code{i} indicates the number of new patients added at interim analysis \code{i}. 
The total sample size at interim \code{i} is the cumulative sum of the values in \code{n} up to that index. 
For example, for four interim analyses with total sample sizes of 10, 15, 20, and 30, 
the vector would be represented as \code{n = c(10, 5, 5, 10)}, where:
\itemize{
  \item 10 is the number of patients enrolled at interim 1,
  \item 5 (15 - 10) is the additional number of patients enrolled at interim 2,
  \item 5 (20 - 15) is the additional number of patients enrolled at interim 3,
  \item 10 (30 - 20) is the additional number of patients enrolled at interim 4.
}}

\item{nsim}{number of simulation}

\item{fb}{vector/matrix of futility boundary at each interim analysis specified 
in the following order: c(resp_1,..., resp_length(n), PFS6_1, ..., PFS6_length(n))}

\item{sb}{vector/matrix  of superiority boundary at each interim analysis specified 
in the following order: c(resp_1,..., resp_length(n), PFS6_1, ..., PFS6_length(n))}

\item{seed}{for reproducibility}
}
\value{
A data frame with the following columns
\describe{
\item{lambda: }{lambda values for cut-off probability}
\item{gamma: }{gamma values for cut-off probability}
\item{eta: }{eta values for cut-off probability}
\item{earlystopfuti_mean: }{Average number of early stopping due to futility}
 \item{earlystopsupe_mean: }{Average number of early stopping for futility due to efficacy}
  \item{ss_mean: }{Average sample size"} 
  \item{rejectnull_mean: }{"Average number of hypothesis rejection at the final analysis (aka Type-I error 
  if the response rate is the null rate or Power if the response rate is the alternative rate.} 
  \item{earlystopfuti_sum: }{Total number of early stopping due to futility} 
  \item{earlystopsupe_sum: }{Total number of early early stopping due to efficacy} 
  \item{ss_sum: }{Sum of sample sizes across simulation"} 
  \item{rejectnull_sum: }{Total number of hypothesis rejection at the final analysis} 
  }
}
\description{
Operating characteristics for for coprimary Endpoint
}
\examples{
H0=c(0.05,0.05, 0.15, 0.75)
a <- H0
seed <- 123
n <- c(10, 5, 5)
method <- "power"
boundary_tab<- get_boundary_coprimary(H0=H0, a=a, n =n,
                               lambda = seq(0, 1, l = 11),
                               gamma  = seq(0, 1, l = 11),
                               eta    = seq(0, 3, l = 31),
                               method = "power",
                               seed=seed)
test_oc<-get_oc_coprimary(
  p1 = 0.05,
  p2 = 0.05,
  p3 = 0.15,
  p4 = 0.75,
  n = c(10, 5, 5),
  nsim = 1000,
  fb = boundary_tab$cnf,
  sb = boundary_tab$cns,
  seed = seed
)
  
}
