% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN_sql.R
\name{.BIEN_sql}
\alias{.BIEN_sql}
\title{Run an SQL query on the BIEN database.}
\usage{
.BIEN_sql(
  query,
  view_full_occurrence_individual = NULL,
  agg_traits = NULL,
  species_by_political_division = NULL,
  bien_species_all = NULL,
  ranges = NULL,
  bien_taxonomy = NULL,
  phylogeny = NULL,
  bien_metadata = NULL,
  plot_metadata = NULL,
  analytical_stem = NULL,
  datasource = NULL,
  centroid = NULL,
  limit = NULL,
  return.query = FALSE,
  schema = NULL,
  print.query = FALSE,
  fetch.query = TRUE,
  record_limit = 10000
)
}
\arguments{
\item{query}{A PostgreSQL query.}

\item{view_full_occurrence_individual}{Alternative value to be substituted for "view_full_occurrence_individual" in queries when not NULL.}

\item{agg_traits}{Alternative value to be substituted for "agg_traits" in queries when not NULL.}

\item{species_by_political_division}{Alternative value to be substituted for "species_by_political_division" in queries when not NULL.}

\item{bien_species_all}{Alternative value to be substituted for "bien_species_all" in queries when not NULL.}

\item{ranges}{Alternative value to be substituted for "ranges" in queries when not NULL.}

\item{bien_taxonomy}{Alternative value to be substituted for "bien_taxonomy" in queries when not NULL.}

\item{phylogeny}{Alternative value to be substituted for "phylogeny" in queries when not NULL.}

\item{bien_metadata}{Alternative value to be substituted for "bien_metadata" in queries when not NULL.}

\item{plot_metadata}{Alternative value to be substituted for "plot_metadata" in queries when not NULL.}

\item{analytical_stem}{Alternative value to be substituted for "analytical_stem" in queries when not NULL.}

\item{datasource}{Alternative value to be substituted for "datasource" in queries when not NULL.}

\item{centroid}{Alternative value to be substituted for "centroid" in queries when not NULL.}

\item{limit}{A limit on the number of records to be returned.  Should be a single number or NULL (the default).}

\item{return.query}{Should  the query used be returned rather than executed?  Default is FALSE}

\item{schema}{An alternative schema to be accessed.  Used for testing purposes.}

\item{print.query}{Should  the query used be printed?  Default is FALSE}

\item{fetch.query}{If TRUE (the default) query is executed using dbFetch.  If FALSE, dbGetQuery is used.}

\item{record_limit}{The number of records to download at once. Defaults to 10000}
}
\value{
A dataframe returned by the query.
}
\description{
.BIEN_sql is an internal function used to submit SQL queries.
}
\note{
Using fetch.query = TRUE provides better error handling, but fetch.query = FALSE results in a more useful (but uncatchable) error.
}
\examples{
\dontrun{
.BIEN_sql("SELECT DISTINCT country, scrubbed_species_binomial FROM view_full_occurrence_individual 
WHERE country in ( 'United States' );")}
}
\keyword{internal}
