% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FINAL_FUNCTIONS_t_test_invm.R
\name{t_test_BFF_invm}
\alias{t_test_BFF_invm}
\title{t_test_BFF_invm}
\usage{
t_test_BFF_invm(
  t_stat,
  n = NULL,
  nu = 1,
  n1 = NULL,
  n2 = NULL,
  one_sample = FALSE,
  alternative = "two.sided",
  omega = NULL,
  omega_sequence = if (is.null(omega)) seq(0.01, 1, by = 0.01),
  default_max = 700
)
}
\arguments{
\item{t_stat}{t statistic}

\item{n}{sample size (if one sample test)}

\item{nu}{hyperparemeter for the inverse moment prior}

\item{n1}{sample size of group one for two sample test. Must be provided if one_sample = FALSE}

\item{n2}{sample size of group two for two sample test. Must be provided if one_sample = FALSE}

\item{one_sample}{is test one sided? Default is FALSE}

\item{alternative}{the alternative. options are "two.sided" or "less" or "greater"}

\item{omega}{standardized effect size. For the t-test, this is often called Cohen's d (can be a single entry or a vector of values)}

\item{omega_sequence}{sequence of standardized effect sizes. If no omega is provided, omega_sequence is set to be seq(0.01, 1, by = 0.01)}

\item{default_max}{set to 700, required for integration to correctly calculate. Authors do not suggest changing this value, as it is for computation only}
}
\value{
Returns an S3 object of class `BFF` (see `BFF.object` for details).
}
\description{
t_test_BFF constructs BFFs based on the t test using the inverse moment prior. BFFs depend on hyperparameters r and tau^2 which determine the shape and scale of the prior distributions which define the alternative hypotheses.
By setting r > 1, we use higher-order moments for replicated studies. Fractional moments are set with r > 1 and r not an integer.
All results are on the log scale.
}
\examples{
tBFF = t_test_BFF_invm(t_stat = 0.5, n = 50, nu = 1, one_sample = TRUE)
tBFF
plot(tBFF)
}
