% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceplane_plot_graph.R
\name{ceplane_plot_graph}
\alias{ceplane_plot_graph}
\alias{ceplane_plot_base.bcea}
\alias{ceplane_plot_base}
\alias{ceplane_plot_ggplot.bcea}
\alias{ceplane_plot_ggplot}
\alias{ceplane_plot_plotly.bcea}
\alias{ceplane_plot_plotly}
\title{Cost-Effectiveness Plane Plot By Graph Device}
\usage{
\method{ceplane_plot_base}{bcea}(he, pos_legend, graph_params, ...)

ceplane_plot_base(he, ...)

\method{ceplane_plot_ggplot}{bcea}(he, pos_legend, graph_params, ...)

ceplane_plot_ggplot(he, ...)

\method{ceplane_plot_plotly}{bcea}(he, wtp = 25000, pos_legend, graph_params, ...)

ceplane_plot_plotly(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{pos_legend}{Legend position}

\item{graph_params}{Graph parameters in \pkg{ggplot2} format}

\item{...}{Additional arguments}

\item{wtp}{Willingness to pay threshold; default 25,000}
}
\value{
For base R returns a plot

For \pkg{ggplot2} returns \pkg{ggplot2} object

For \pkg{plotly} returns a plot in the Viewer
}
\description{
Choice of base R, \pkg{ggplot2} or \pkg{plotly}.
}
\examples{
# single comparator
data(Vaccine, package = "BCEA")

he <- bcea(eff, cost)
ceplane.plot(he, graph = "base")

\dontrun{
# need to provide all the defaults because thats what
# ceplane.plot() does

graph_params <-  list(xlab = "x-axis label",
                      ylab = "y-axis label",
                      title = "my title",
                      xlim = c(-0.002, 0.001),
                      ylim = c(-13, 5),
                      point = list(sizes = 1,
                                   colors = "darkgrey"),
                      area = list(color = "lightgrey"))
                      
he$delta_e <- as.matrix(he$delta_e)
he$delta_c <- as.matrix(he$delta_c)

BCEA::ceplane_plot_base(he, graph_params = graph_params)

## single non-default comparator


## multiple comparators
data(Smoking)

graph_params <-  list(xlab = "x-axis label",
                      ylab = "y-axis label",
                      title = "my title",
                      xlim = c(-1, 2.5),
                      ylim = c(-1, 160),
                      point = list(sizes = 0.5,
                                   colors = grey.colors(3, start = 0.1, end = 0.7)),
                      area = list(color = "lightgrey"))
                                   
he <- bcea(eff, cost, ref = 4, Kmax = 500, interventions = treats)

BCEA::ceplane_plot_base(he,
                        wtp = 200,
                        pos_legend = FALSE,
                        graph_params = graph_params)
}


data(Vaccine)
he <- bcea(eff, cost)

ceplane.plot(he, graph = "ggplot2")
ceplane.plot(he, wtp=10000, graph = "ggplot2",
             point = list(colors = "blue", sizes = 2),
             area = list(col = "springgreen3"))

data(Smoking)
he <- bcea(eff, cost, ref = 4, Kmax = 500, interventions = treats)

ceplane.plot(he, graph = "ggplot2")

ceplane.plot(he,
             wtp = 200,
             pos = "right",
             ICER_size = 2,
             graph = "ggplot2")
   
ceplane.plot(he,
             wtp = 200,
             pos = TRUE,
             graph = "ggplot2")

ceplane.plot(he,
             graph = "ggplot2",
             wtp=200,
             theme = ggplot2::theme_linedraw())
             
}
\keyword{hplot}
