% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plots.ModelEvaluation}
\alias{Plots.ModelEvaluation}
\title{Plots.ModelEvaluation}
\usage{
Plots.ModelEvaluation(
  dt = NULL,
  AggMethod = "mean",
  SampleSize = 100000L,
  PlotType = NULL,
  YVar = NULL,
  TargetLevel = NULL,
  ZVar = NULL,
  XVar = NULL,
  GroupVar = NULL,
  YVarTrans = "Identity",
  XVarTrans = "Identity",
  ZVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  NumLevels_Y = 75,
  NumLevels_X = 40,
  MouseScroll = FALSE,
  Height = NULL,
  Width = NULL,
  Title = NULL,
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  EchartsTheme = "dark-blue",
  TimeLine = FALSE,
  TextColor = "white",
  FontSize = 14L,
  NumberBins = 20,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{AggMethod}{character}

\item{SampleSize}{100000L}

\item{PlotType}{character}

\item{YVar}{Y-Axis variable name}

\item{TargetLevel}{character}

\item{ZVar}{Z-Axis variable name}

\item{XVar}{X-Axis variable name}

\item{GroupVar}{Character variable}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{XVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{ZVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{NumLevels_Y}{= 75}

\item{NumLevels_X}{= 40}

\item{MouseScroll}{logical, zoom via mouse scroll}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{character}

\item{ShowLabels}{logical}

\item{Title.YAxis}{character}

\item{Title.XAxis}{character}

\item{EchartsTheme}{"auritus","azul","bee-inspired","blue","caravan","carp","chalk","cool","dark-bold","dark","eduardo", #' "essos","forest","fresh-cut","fruit","gray","green","halloween","helianthus","infographic","inspired", #' "jazz","london","dark","macarons","macarons2","mint","purple-passion","red-velvet","red","roma","royal", #' "sakura","shine","tech-blue","vintage","walden","wef","weforum","westeros","wonderland"}

\item{TimeLine}{logical}

\item{TextColor}{hex}

\item{FontSize}{numeric}

\item{NumberBins}{numeric}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
Plot helper for model evaluation plot types
}
\seealso{
Other Auto Plotting: 
\code{\link{Plot.StandardPlots}()}
}
\author{
Adrian Antico
}
\concept{Auto Plotting}
