% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/black_scholes.R
\name{price_black_scholes_put}
\alias{price_black_scholes_put}
\title{Black-Scholes European Put Option Price}
\usage{
price_black_scholes_put(S0, K, r, sigma, time_to_maturity)
}
\arguments{
\item{S0}{Initial stock price (must be positive)}

\item{K}{Strike price (must be positive)}

\item{r}{Continuously compounded risk-free rate (e.g., 0.05 for 5\% annual rate)}

\item{sigma}{Volatility (annualized standard deviation, must be non-negative)}

\item{time_to_maturity}{Time to maturity in years (must be positive)}
}
\value{
European put option price (numeric)
}
\description{
Computes the exact price of a European put option using the classical
Black-Scholes (1973) analytical formula.
}
\details{
The Black-Scholes formula for a European put option is:
\deqn{P = K e^{-rT} N(-d_2) - S_0 N(-d_1)}

where:
\deqn{d_1 = \frac{\log(S_0/K) + (r + \sigma^2/2)T}{\sigma\sqrt{T}}}
\deqn{d_2 = d_1 - \sigma\sqrt{T}}

and \eqn{N(\cdot)} is the cumulative standard normal distribution function.

Alternatively, the put price can be derived from put-call parity:
\deqn{P = C - S_0 + K e^{-rT}}
}
\section{Put-Call Parity}{

The Black-Scholes put and call prices satisfy:
\deqn{C - P = S_0 - K e^{-rT}}

This relationship holds exactly for European options without dividends.
}

\examples{
price_black_scholes_put(S0 = 100, K = 100, r = 0.05, sigma = 0.2,
                        time_to_maturity = 1)

}
\references{
Black, F., & Scholes, M. (1973). The Pricing of Options and Corporate Liabilities.
\emph{Journal of Political Economy}, 81(3), 637-654.
\doi{10.1086/260062}
}
\seealso{
\code{\link{price_black_scholes_call}}
}
