% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_get.R
\name{zz_get}
\alias{zz_get}
\title{Get file from Zamzar endpoint}
\usage{
zz_get(
  id = NULL,
  usr = NULL,
  name = NULL,
  extension = NULL,
  overwrite = FALSE,
  prod = FALSE
)
}
\arguments{
\item{id}{The target id for a previously passed file. Most likely
returned from `zz_get_info()`.}

\item{usr}{The username/API key you are using. If not set, `zz_format()`
will see if a key exists as a `ZAMZAR_USR` variable  in `.Renviron` and use that.    

See: \url{https://developers.zamzar.com/user}}

\item{name}{The name of the file you are fetching from Zamzar. If a name is
not assigned to the file, then we're using the id as file name.}

\item{extension}{The extension of the file you are fetching from Zamzar.}

\item{overwrite}{Should `zz_get()` overwrite if a file with the same name already
exists in directory. Defaults to `FALSE`.}

\item{prod}{Boolean deciding whether to use a production endpoint or
a development endpoint. Defaults to FALSE (That is, development endpoint).}
}
\value{
A file written to disk.
}
\description{
Get file from Zamzar endpoint via id.
Per default `zz_get()` assumes that you're doing development, thus using a 
development endpoint. Set prod boolean to `TRUE` to change this behavior.
}
\details{
Please note that a Zamzar key passed as argument to `usr` takes precedence over a
Zamzar key extracted from an `.Renviron`.
}
\examples{
\dontrun{
# An example of zz_get() utilized with hardcoded arguments
zz_get(id = 12345678, usr = "key", name = "my_avatar", extension = "png")

# An example zz_get() used in conjunction with zz_get_info()
# Please note this example assumes a valid key in .Renviron
response <- zz_get_info(latest = TRUE)
zz_get(id = response$id, extension = response$extension, prod = TRUE)
}
}
