% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicate.R
\name{Replicate}
\alias{Replicate}
\title{Replicate a module multiple times}
\usage{
Replicate(call, n)
}
\arguments{
\item{call}{A module call, e.g. UKAnophelesPlumbeus}

\item{n}{The number of times to replicate the call}
}
\value{
A list of calls
}
\description{
This function is useful when running simulations and could be used
with modules that have random number generation internally meaning that
results from identical runs are different. Replicate gives the same result
as using list() and repeating the module multiple times.
}
\examples{
# run a workflow, using the logistic regression model
\dontrun{

Without Replicate
work1 <- workflow(occurrence = list(UKAnophelesPlumbeus,UKAnophelesPlumbeus,UKAnophelesPlumbeus),
               covariate = UKAir,
               process = OneHundredBackground,
               model = LogisticRegression,
               output = SameTimePlaceMap)
# With Replicate
work2 <- workflow(occurrence = Replicate(UKAnophelesPlumbeus, 3),
               covariate = UKAir,
               process = OneHundredBackground,
               model = LogisticRegression,
               output = SameTimePlaceMap)
# The workflows are the same
plot(work1)
plot(work2)

# Output plots show the random placement of background points
# in each run
work1 <- workflow(occurrence = UKAnophelesPlumbeus,
                 covariate = UKAir,
                 process = Replicate(Background(n=10), n = 10),
                 model = LogisticRegression,
                 output = PrintMap)

}
}
