use super::*;











#[derive(PartialEq, Clone)]
pub struct Symbol {
    pub(crate) robj: Robj,
}

impl Symbol {









    pub fn from_string<S: AsRef<str>>(val: S) -> Self {
        let val = val.as_ref();
        Symbol {
            robj: Robj::from_sexp(make_symbol(val)),
        }
    }


    fn from_sexp(sexp: SEXP) -> Symbol {
        unsafe {
            assert!(TYPEOF(sexp) == SEXPTYPE::SYMSXP);
        }
        Symbol {
            robj: Robj::from_sexp(sexp),
        }
    }








    pub fn as_str(&self) -> &str {
        unsafe {
            let sexp = self.robj.get();
            let printname = PRINTNAME(sexp);
            rstr::charsxp_to_str(printname).unwrap()
        }
    }
}

impl From<&str> for Symbol {

    fn from(name: &str) -> Self {
        Symbol::from_string(name)
    }
}


pub fn unbound_value() -> Symbol {
    unsafe { Symbol::from_sexp(R_UnboundValue) }
}


pub fn missing_arg() -> Symbol {
    unsafe { Symbol::from_sexp(R_MissingArg) }
}


pub fn base_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_BaseSymbol) }
}


pub fn brace_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_BraceSymbol) }
}


pub fn bracket_2_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_Bracket2Symbol) }
}


pub fn bracket_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_BracketSymbol) }
}


pub fn class_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_ClassSymbol) }
}


pub fn device_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_DeviceSymbol) }
}


pub fn dimnames_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_DimNamesSymbol) }
}


pub fn dim_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_DimSymbol) }
}


pub fn dollar_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_DollarSymbol) }
}


pub fn dots_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_DotsSymbol) }
}



pub fn double_colon_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_DoubleColonSymbol) }
}


pub fn lastvalue_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_LastvalueSymbol) }
}

pub fn levels_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_LevelsSymbol) }
}

pub fn mode_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_ModeSymbol) }
}

pub fn na_rm_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_NaRmSymbol) }
}

pub fn name_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_NameSymbol) }
}

pub fn names_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_NamesSymbol) }
}

pub fn namespace_env_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_NamespaceEnvSymbol) }
}

pub fn package_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_PackageSymbol) }
}

pub fn previous_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_PreviousSymbol) }
}

pub fn quote_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_QuoteSymbol) }
}

pub fn row_names_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_RowNamesSymbol) }
}

pub fn seeds_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_SeedsSymbol) }
}

pub fn sort_list_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_SortListSymbol) }
}

pub fn source_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_SourceSymbol) }
}

pub fn spec_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_SpecSymbol) }
}

pub fn tsp_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_TspSymbol) }
}

pub fn triple_colon_symbol() -> Symbol {
    unsafe { Symbol::from_sexp(R_TripleColonSymbol) }
}

pub fn dot_defined() -> Symbol {
    unsafe { Symbol::from_sexp(R_dot_defined) }
}

pub fn dot_method() -> Symbol {
    unsafe { Symbol::from_sexp(R_dot_Method) }
}

pub fn dot_package_name() -> Symbol {
    unsafe { Symbol::from_sexp(R_dot_packageName) }
}


pub fn dot_target() -> Symbol {
    unsafe { Symbol::from_sexp(R_dot_target) }
}

#[cfg(test)]
mod test {
    use super::*;

    #[test]
    fn test_constant_symbols() {
        test! {
            assert!(unbound_value().is_symbol());
            assert!(missing_arg().is_symbol());
            assert!(base_symbol().is_symbol());
            assert!(brace_symbol().is_symbol());
            assert!(bracket_2_symbol().is_symbol());
            assert!(bracket_symbol().is_symbol());
            assert!(class_symbol().is_symbol());
            assert!(device_symbol().is_symbol());
            assert!(dimnames_symbol().is_symbol());
            assert!(dim_symbol().is_symbol());
            assert!(dollar_symbol().is_symbol());
            assert!(dots_symbol().is_symbol());
            assert!(lastvalue_symbol().is_symbol());
            assert!(levels_symbol().is_symbol());
            assert!(mode_symbol().is_symbol());
            assert!(na_rm_symbol().is_symbol());
            assert!(name_symbol().is_symbol());
            assert!(names_symbol().is_symbol());
            assert!(namespace_env_symbol().is_symbol());
            assert!(package_symbol().is_symbol());
            assert!(previous_symbol().is_symbol());
            assert!(quote_symbol().is_symbol());
            assert!(row_names_symbol().is_symbol());
            assert!(seeds_symbol().is_symbol());
            assert!(sort_list_symbol().is_symbol());
            assert!(source_symbol().is_symbol());
            assert!(spec_symbol().is_symbol());
            assert!(tsp_symbol().is_symbol());
            assert!(triple_colon_symbol().is_symbol());
            assert!(dot_defined().is_symbol());
            assert!(dot_method().is_symbol());
            assert!(dot_package_name().is_symbol());
            assert!(dot_target().is_symbol());
        }
    }
}
