























#![warn(rust_2018_idioms)]

use std::env;

include!("no_atomic.rs");
include!("build-common.rs");

fn main() {
    let target = match env::var("TARGET") {
        Ok(target) => convert_custom_linux_target(target),
        Err(e) => {
            println!(
                "cargo:warning={}: unable to get TARGET environment variable: {}",
                env!("CARGO_PKG_NAME"),
                e
            );
            return;
        }
    };




    if NO_ATOMIC_CAS.contains(&&*target) {
        println!("cargo:rustc-cfg=crossbeam_no_atomic_cas");
    }
    if NO_ATOMIC.contains(&&*target) {
        println!("cargo:rustc-cfg=crossbeam_no_atomic");
        println!("cargo:rustc-cfg=crossbeam_no_atomic_64");
    } else if NO_ATOMIC_64.contains(&&*target) {
        println!("cargo:rustc-cfg=crossbeam_no_atomic_64");
    } else {

    }

    println!("cargo:rerun-if-changed=no_atomic.rs");
}
