% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-input.R
\name{write_dat}
\alias{write_dat}
\title{Write a Zonation run configuration (dat) file.}
\usage{
write_dat(x, filename, overwrite = FALSE)
}
\arguments{
\item{x}{List containing the data to be written.}

\item{filename}{String file path.}

\item{overwrite}{Logical indicating whether the file should be overwritten.}
}
\value{
Invisible null.
}
\description{
The function takes a nested list of values and writes it to a dat file (a
Windows style .ini-file).
}
\note{
Only 1 level of nestedness is accepted.
}
\examples{
  \dontrun{
      dat <- list("Settings" = list("removal_rule" = 1, use_groups = 1))
      write_dat(dat, "settings.dat")
  }

}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
