% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ZCurvesDataFrame-methods.R,
%   R/zresults-methods.R, R/zvariant-methods.R
\docType{methods}
\name{featurenames}
\alias{featurenames}
\alias{featurenames<-}
\alias{featurenames,ZCurvesDataFrame-method}
\alias{featurenames<-}
\alias{featurenames<-,ZCurvesDataFrame,character-method}
\alias{featurenames,Zresults-method}
\alias{featurenames,Zvariant-method}
\alias{featurenames<-}
\alias{featurenames<-,Zvariant,character-method}
\title{Feature names of Zonation variant.}
\usage{
featurenames(x)

featurenames(x) <- value

\S4method{featurenames}{ZCurvesDataFrame}(x)

\S4method{featurenames}{ZCurvesDataFrame,character}(x) <- value

\S4method{featurenames}{Zresults}(x)

\S4method{featurenames}{Zvariant}(x)

\S4method{featurenames}{Zvariant,character}(x) <- value
}
\arguments{
\item{x}{Z* object.}

\item{value}{character vector of feature names to be assigned. Can be named
or not.}
}
\value{
Character vector of spp feature names.
}
\description{
Get and set names for analysis features used a given
Zonation variant.

Assign feature names for a Zonation variant.
}
\details{
Argument \code{x} can be an instance of one the following Z* classes:
\itemize{
  \item{\code{Zvariant}}
  \item{\code{Zresults}}
}
}
\note{
spp features have by default names that are derived from the feature
raster file path.
}
\examples{
\dontrun{
 setup.dir <- system.file("extdata/tutorial/basic", package="zonator")
 tutorial.project <- create_zproject(setup.dir)
 variant.caz <- get_variant(tutorial.project, "01")

 # Feature names for a Zvariant object
 featurenames(variant.caz)

 # Feature names for a Zresults object
 results.caz <- results(variant.caz)
 featurenames(results.caz)
}

}
\seealso{
\code{\link{Zvariant-class}} \code{\link{Zresults-class}}
         \code{\link{groupnames}} \code{\link{groups}}
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
