% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zonation.R
\name{ds_alpha}
\alias{ds_alpha}
\title{Calculate alpha value for distribution smoothing.}
\usage{
ds_alpha(landscape.use, ratio)
}
\arguments{
\item{landscape.use}{Use of landscape (in relation to connectivity) in given
map units. Note that if the units used here differ from the real map units
of the biodiversity feature the ratio between two must be set using
\code{ratio} argument.}

\item{ratio}{Defines the ratio between units used in \code{landscape.use} and
the actual map units in the biodiversity feature. E.g. if the map unit of
a feature is m and use of landscape is defined as 1.5 km, then ratio should
be set to 1000.}
}
\value{
numerical alpha.
}
\description{
alpha-value of biodiversity feature-specific scale of landscape use. The
value indicates the range of connectivity of biodiversity features. For
example, it may refer to how a species uses the surrounding landscape. This
value can be calculated based on, for example, the dispersal capability or
the home range sizes of the species.
}
\examples{
  ds_alpha(1.5, 1000)

}
\seealso{
Zonation manual.
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
