% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmmsim2_exp.R
\name{hsmmsim2_exp}
\alias{hsmmsim2_exp}
\title{Simulate a hidden semi-Markov series and its underlying states with covariates}
\usage{
hsmmsim2_exp(prior, dtrate, dtparm, zeroparm, emitparm, tpmparm, trunc, M, n,
  dt_x = NULL, tpm_x = NULL, emit_x = NULL, zeroinfl_x = NULL)
}
\arguments{
\item{prior}{a vector of prior probabilities}

\item{dtrate}{a vector for the scale parameters in the base exponential
density for the latent state durations.}

\item{dtparm}{a matrix of coefficients for the accelerated failure time
model in each latent state}

\item{zeroparm}{a vector of regression coefficients for the structural
zero proportion in state 1}

\item{emitparm}{a matrix of regression coefficients for the Poisson
regression in each state}

\item{tpmparm}{a vector of coefficients for the multinomial logistic
regression in the transition probabilities}

\item{trunc}{a vector}

\item{M}{number of latent states}

\item{n}{length of the simulated series}

\item{dt_x}{if dt_dist is "nonparametric", then dt_x is the matrix of nonparametric 
state durataion probabilities. Otherwise, dt_x is matrix of covariates for the dwell time distribution 
parameters in log-series or shifted-poisson distributions.Default to NULL.}

\item{tpm_x}{matrix of covariates for transition probability matrix (excluding the 1st column).
Default to NULL.}

\item{emit_x}{matrix of covariates for the log poisson means. Default to NULL.}

\item{zeroinfl_x}{matrix of covariates for the nonzero structural zero proportions. Default to NULL.}
}
\value{
simulated series and corresponding states
}
\description{
Simulate a hidden semi-Markov series and its underlying states with covariates
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
