% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zbeta_log_rsq_over_expected.R
\name{Zbeta_log_rsq_over_expected}
\alias{Zbeta_log_rsq_over_expected}
\title{Runs the Zbeta function on the log of the r-squared values over the expected r-squared values for the region}
\usage{
Zbeta_log_rsq_over_expected(
  pos,
  ws,
  x,
  dist,
  LDprofile_bins,
  LDprofile_rsq,
  minRandL = 4,
  minRL = 25,
  X = NULL
)
}
\arguments{
\item{pos}{A numeric vector of SNP locations}

\item{ws}{The window size which the \eqn{Z_{\beta}^{log_{10}(r^2/E[r^2])}}{Zbeta} statistic will be calculated over. This should be on the same scale as the \code{pos} vector.}

\item{x}{A matrix of SNP values. Columns represent chromosomes; rows are SNP locations. Hence, the number of rows should equal the length of the \code{pos} vector. SNPs should all be biallelic.}

\item{dist}{A numeric vector of genetic distances (e.g. cM, LDU). This should be the same length as \code{pos}.}

\item{LDprofile_bins}{A numeric vector containing the lower bound of the bins used in the LD profile. These should be of equal size.}

\item{LDprofile_rsq}{A numeric vector containing the expected \eqn{r^2}{r^2} values for the corresponding bin in the LD profile. Must be between 0 and 1.}

\item{minRandL}{Minimum number of SNPs in each set R and L for the statistic to be calculated. Default is 4.}

\item{minRL}{Minimum value for the product of the set sizes for R and L. Default is 25.}

\item{X}{Optional. Specify a region of the chromosome to calculate \eqn{Z_{\beta}^{log_{10}(r^2/E[r^2])}}{Zbeta} for in the format \code{c(startposition, endposition)}. The start position and the end position should be within the extremes of the positions given in the \code{pos} vector. If not supplied, the function will calculate \eqn{Z_{\beta}^{log_{10}(r^2/E[r^2])}}{Zbeta} for every SNP in the \code{pos} vector.}
}
\value{
A list containing the SNP positions and the \eqn{Z_{\beta}^{log_{10}(r^2/E[r^2])}}{Zbeta} values for those SNPs
}
\description{
Returns a \eqn{Z_{\beta}^{log_{10}(r^2/E[r^2])}}{Zbeta} value for each SNP location supplied to the function, based on
the expected \eqn{r^2} values given an LD profile and genetic distances.
For more information about the \eqn{Z_{\beta}^{log_{10}(r^2/E[r^2])}}{Zbeta} statistic, please see Jacobs (2016).
The \eqn{Z_{\beta}^{log_{10}(r^2/E[r^2])}}{Zbeta} statistic is defined as:
\deqn{Z_{\beta}^{log_{10}(r^2/E[r^2])}=\frac{\sum_{i \in L,j \in R}log_{10}(r^2_{i,j}/E[r^2_{i,j}])}{|L||R|}}
where \code{|L|} and \code{|R|} are the number of SNPs to the left and right of the current locus within the given window \code{ws}, \eqn{r^2}{r^2} is equal to
the squared correlation between a pair of SNPs, and \eqn{E[r^2]}{E[r^2]} is equal to the expected squared correlation between a pair of SNPs, given an LD profile.
}
\details{
The LD profile describes the expected correlation between SNPs at a given genetic distance, generated using simulations or
real data. Care should be taken to utilise an LD profile that is representative of the population in question. The LD
profile should consist of evenly sized bins of distances (for example 0.0001 cM per bin), where the value given is the (inclusive) lower
bound of the bin. Ideally, an LD profile would be generated using data from a null population with no selection, however one can be generated
using this data. See the \code{\link{create_LDprofile}} function for more information on how to create an LD profile.
}
\examples{
## load the snps and LDprofile example datasets
data(snps)
data(LDprofile)
## run Zbeta_log_rsq_over_expected over all the SNPs with a window size of 3000 bp
Zbeta_log_rsq_over_expected(snps$bp_positions,3000,as.matrix(snps[,3:12]),snps$cM_distances,
 LDprofile$bin,LDprofile$rsq)
## only return results for SNPs between locations 600 and 1500 bp
Zbeta_log_rsq_over_expected(snps$bp_positions,3000,as.matrix(snps[,3:12]),snps$cM_distances,
 LDprofile$bin,LDprofile$rsq,X=c(600,1500))

}
\references{
Jacobs, G.S., T.J. Sluckin, and T. Kivisild, \emph{Refining the Use of Linkage Disequilibrium as a Robust Signature of Selective Sweeps.} Genetics, 2016. \strong{203}(4): p. 1807
}
\seealso{
\code{\link{create_LDprofile}}
}
