% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yields.R
\name{ypr_yields}
\alias{ypr_yields}
\title{Yields}
\usage{
ypr_yields(population, pi = seq(0, 1, length.out = 100), Ly = 0,
  harvest = TRUE, biomass = FALSE)
}
\arguments{
\item{population}{An object of class \code{\link{ypr_population}}.}

\item{pi}{A vector of probabilities of capture to calculate the yield for.}

\item{Ly}{The minimum length (trophy) fish to consider when calculating the yield.}

\item{harvest}{A flag indicating whether to calculate the yield for harvested fish or captures.}

\item{biomass}{A flag indicating whether to calculate the yield in terms of the biomass versus number of individuals.}
}
\value{
A numeric vector of the yields.
}
\description{
Calculates the yield(s) for a population based on one or more capture rates.
}
\examples{
pi <- seq(0, 1, length.out = 30)
plot(pi, ypr_yields(ypr_population(), pi), type = "l")
}
\seealso{
\code{\link{ypr_yield}}
}
