% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sr.R
\name{ypr_sr}
\alias{ypr_sr}
\title{Stock-Recruitment Parameters}
\usage{
ypr_sr(population)
}
\arguments{
\item{population}{An object of class \code{\link{ypr_population}}.}
}
\value{
A data frame of the SR parameters.
}
\description{
Returns a single rowed data frame of the SR parameters:
\describe{
  \item{alpha}{Survival from egg to age tR at low density}
  \item{beta}{Density-dependence}
  \item{Rk}{Spawners per spawner at low density}
  \item{phi}{Eggs deposited at unfished equilibrium}
  \item{phiF}{Eggs deposited at the fished equilibrium}
  \item{R0}{Age tR recruits at the unfished equilibrium}
  \item{R0F}{Age tR recruits at the fished equilibrium}
  \item{S0}{Spawners at the unfished equilibrium}
  \item{S0F}{spawners at the fished equilibrium}
}
}
\examples{
ypr_sr(ypr_population()) # Beverton-Holt
ypr_sr(ypr_population(BH = 0L)) # Ricker
}
