% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{scroll}
\alias{scroll}
\title{Vertical and horizontal scroll}
\usage{
scroll(tag, direction = "vertical")
}
\arguments{
\item{tag}{A tag element.}

\item{direction}{One of \code{"horizontal"} or \code{"vertical"} specifying which
direction to scroll overflowing content, defaults to \code{"vertical"}, in which
case the content may croll up and down.}
}
\description{
Many of the applications you build despite a complex layout will still fit
onto a single page. To help scroll long content alongside shorter content use
the \code{scroll()} utility function.
}
\examples{

### A simple scroll

div(
  lapply(
    rep("Integer placerat tristique nisl.", 20),
    . \%>\% p() \%>\% margin(bottom = 2)
  )
) \%>\%
  height(20) \%>\%
  border("black") \%>\%
  scroll()

}
\seealso{
Other design utilities: \code{\link{active}},
  \code{\link{affix}}, \code{\link{background}},
  \code{\link{border}}, \code{\link{display}},
  \code{\link{float}}, \code{\link{font}},
  \code{\link{height}}, \code{\link{padding}},
  \code{\link{shadow}}, \code{\link{width}}
}
\concept{design utilities}
