% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alert.R
\name{alert}
\alias{alert}
\title{Alert boxes}
\usage{
alert(..., dismissible = TRUE, fade = TRUE)
}
\arguments{
\item{...}{Character strings specifying the text of the alert or additional
named arguments passed as HTML attributes to the alert element.}

\item{dismissible}{One of \code{TRUE} or \code{FALSE} specifying if the alert may be
dismissed by the user, deafults to \code{TRUE}.}

\item{fade}{One of \code{TRUE} or \code{FALSE} specifying if the alert fades out or
immediately disappears when dismissed, defaults to \code{TRUE}.}
}
\description{
Use an alert element to let the user know of successes or to call attention
to problems.
}
\examples{

### Default alert

alert("Donec at pede.") \%>\%
  background("blue")

### A more complex alert

alert(
  h4("Etiam vel tortor sodales"),
  hr(),
  p("Fusce commodo.")
) \%>\%
  background("amber")

}
\seealso{
Other components: \code{\link{badge}},
  \code{\link{blockquote}}, \code{\link{card}},
  \code{\link{collapsePane}}, \code{\link{d1}},
  \code{\link{dropdown}}, \code{\link{img}},
  \code{\link{jumbotron}}, \code{\link{modal}},
  \code{\link{navContent}}, \code{\link{popover}},
  \code{\link{pre}}, \code{\link{toast}}
}
\concept{components}
