% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_latex.R
\name{yml_latex_opts}
\alias{yml_latex_opts}
\title{Set LaTeX YAML options for PDF output}
\usage{
yml_latex_opts(
  .yml,
  block_headings = yml_blank(),
  classoption = yml_blank(),
  documentclass = yml_blank(),
  geometry = yml_blank(),
  indent = yml_blank(),
  linestretch = yml_blank(),
  margin_left = yml_blank(),
  margin_right = yml_blank(),
  margin_top = yml_blank(),
  margin_bottom = yml_blank(),
  pagestyle = yml_blank(),
  papersize = yml_blank(),
  secnumdepth = yml_blank(),
  fontenc = yml_blank(),
  fontfamily = yml_blank(),
  fontfamilyoptions = yml_blank(),
  fontsize = yml_blank(),
  mainfont = yml_blank(),
  sansfont = yml_blank(),
  monofont = yml_blank(),
  mathfont = yml_blank(),
  CJKmainfont = yml_blank(),
  mainfontoptions = yml_blank(),
  sansfontoptions = yml_blank(),
  monofontoptions = yml_blank(),
  mathfontoptions = yml_blank(),
  CJKoptions = yml_blank(),
  microtypeoptions = yml_blank(),
  colorlinks = yml_blank(),
  linkcolor = yml_blank(),
  filecolor = yml_blank(),
  citecolor = yml_blank(),
  urlcolor = yml_blank(),
  toccolor = yml_blank(),
  links_as_notes = yml_blank(),
  lof = yml_blank(),
  lot = yml_blank(),
  thanks = yml_blank(),
  toc = yml_blank(),
  toc_depth = yml_blank(),
  biblatexoptions = yml_blank(),
  biblio_style = yml_blank(),
  biblio_title = yml_blank(),
  bibliography = yml_blank(),
  natbiboptions = yml_blank()
)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{block_headings}{make paragraph and subparagraph (fourth- and
fifth-level headings, or fifth- and sixth-level with book classes)
free-standing rather than run-in; requires further formatting to
distinguish from subsubsection (third- or fourth-level headings). Note that
the YAML field is actually called \code{block-headings}.}

\item{classoption}{a character vector of options for document class, e.g.
"oneside"}

\item{documentclass}{the document class usually "article", "book", or
"report"}

\item{geometry}{a character vector of options for the \href{https://ctan.org/pkg/geometry?lang=en}{geometry LaTeX package}, e.g. "margin=1in"}

\item{indent}{Logical. Use document class settings for indentation? The
default LaTeX template otherwise removes indentation and adds space between
paragraphs.}

\item{linestretch}{adjusts line spacing using the \href{https://ctan.org/pkg/setspace?lang=en}{setspace LaTeX package}, e.g. 1.25, 1.5}

\item{margin_left, margin_right, margin_top, margin_bottom}{sets margins if
\code{geometry} is not used, otherwise \code{geometry} overrides these. Note that the
actual YAML fields use \code{-} instead of \verb{_}, e.g. \code{margin-left}.}

\item{pagestyle}{control the \code{pagestyle} LaTeX command: the default article
class supports "plain" (default), "empty" (no running heads or page
numbers), and "headings" (section titles in running heads)}

\item{papersize}{paper size, e.g. letter, a4}

\item{secnumdepth}{numbering depth for sections (with \code{--number-sections}
pandoc)}

\item{fontenc}{allows font encoding to be specified through \href{https://www.ctan.org/pkg/fontenc}{fontenc LaTeX package} (with pdflatex); default is "T1"
(see \href{https://ctan.org/pkg/encguide}{LaTeX font encodings guide})}

\item{fontfamily}{font package for use with pdflatex: TeX Live includes many
options, documented in the \href{https://tug.org/FontCatalogue/}{LaTeX Font Catalogue}. The default is "Latin Modern".}

\item{fontfamilyoptions}{a character vector of options for \code{fontfamily}.}

\item{fontsize}{font size for body text. The standard classes allow "10pt",
"11pt", and "12pt".}

\item{mainfont, sansfont, monofont, mathfont, CJKmainfont}{font families for use
with xelatex or lualatex: take the name of any system font, using the
\href{https://www.ctan.org/pkg/fontspec}{fontspec LaTeX package}. CJKmainfont
uses the \href{https://www.ctan.org/pkg/xecjk}{xecjk LaTeX package.}.}

\item{mainfontoptions, sansfontoptions, monofontoptions, mathfontoptions, CJKoptions}{a
character vector of options to use with mainfont, sansfont, monofont,
mathfont, CJKmainfont in xelatex and lualatex. Allow for any choices
available through fontspec.}

\item{microtypeoptions}{a character vector of options to pass to the
\href{https://www.ctan.org/pkg/microtype}{microtype LaTeX package}.}

\item{colorlinks}{Logical. Add color to link text? Automatically enabled if
any of \code{linkcolor}, \code{filecolor}, \code{citecolor}, \code{urlcolor}, or \code{toccolor} are
set.}

\item{linkcolor, filecolor, citecolor, urlcolor, toccolor}{color for internal
links, external links, citation links, linked URLs, and links in table of
contents, respectively: uses options allowed by
\href{https://ctan.org/pkg/xcolor?lang=en}{xcolor}, including the dvipsnames,
svgnames, and x11names lists}

\item{links_as_notes}{Logical. Print links as footnotes? Note that the actual
YAML field is \code{links-as-notes}}

\item{lof, lot}{Logical. Include list of figures or list of tables?}

\item{thanks}{contents of acknowledgments footnote after document title}

\item{toc}{include table of contents}

\item{toc_depth}{level of section to include in table of contents. Note that
the actual YAML field is \code{toc-depth}}

\item{biblatexoptions}{list of options for
\href{https://ctan.org/pkg/biblatex}{biblatex}.}

\item{biblio_style}{bibliography style, when used with
\href{https://ctan.org/pkg/natbib}{natbib} and
\href{https://ctan.org/pkg/biblatex}{biblatex}. Note that the actual YAML field
is \code{biblio-style}}

\item{biblio_title}{bibliography title, when used with
\href{https://ctan.org/pkg/natbib}{natbib} and
\href{https://ctan.org/pkg/biblatex}{biblatex}. Note that the actual YAML field
is \code{biblio-title}}

\item{bibliography}{a path to the bibliography file to use for references}

\item{natbiboptions}{a character vector of options for
\href{https://ctan.org/pkg/natbib}{natbib}}
}
\value{
a \code{yml} object
}
\description{
\code{yml_latex_opts()} sets top-level YAML fields for LaTeX options used by
pandoc (\href{https://pandoc.org/MANUAL.html}{see the documentation}, from which
these descriptions were derived), as when making a PDF document with
\code{pdf_document()}.
}
\examples{
\donttest{
yml() \%>\%
   yml_output(pdf_document()) \%>\%
   yml_latex_opts(
     fontfamily = "Fira Sans Thin",
     fontsize = "11pt",
     links_as_notes = TRUE
   )
}
}
\seealso{
Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{use_yml}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}
}
\concept{yml}
