% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fair-equal_opportunity.R
\name{equal_opportunity}
\alias{equal_opportunity}
\title{Equal opportunity}
\usage{
equal_opportunity(by)
}
\arguments{
\item{by}{The column identifier for the sensitive feature. This should be an
unquoted column name referring to a column in the un-preprocessed data.}
}
\value{
This function outputs a yardstick \emph{fairness metric} function. Given a
grouping variable \code{by}, \code{equal_opportunity()} will return a yardstick metric
function that is associated with the data-variable grouping \code{by} and a
post-processor. The outputted function will first generate a set
of sens metric values by group before summarizing across
groups using the post-processing function.

The outputted function only has a data frame method and is intended to
be used as part of a metric set.
}
\description{
Equal opportunity is satisfied when a model's predictions have the same
true positive and false negative rates across protected groups. A value of
0 indicates parity across groups.

\code{equal_opportunity()} is calculated as the difference between the largest
and smallest value of \code{\link[=sens]{sens()}} across groups.

Equal opportunity is sometimes referred to as equality of opportunity.

See the "Measuring Disparity" section for details on implementation.
}
\section{Measuring Disparity}{

By default, this function takes the difference in range of sens
\code{.estimate}s across groups. That is, the maximum pair-wise disparity between
groups is the return value of \code{equal_opportunity()}'s \code{.estimate}.

For finer control of group treatment, construct a context-aware fairness
metric with the \code{\link[=new_groupwise_metric]{new_groupwise_metric()}} function by passing a custom \code{aggregate}
function:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# the actual default `aggregate` is:
diff_range <- function(x, ...) \{diff(range(x$.estimate))\}

equal_opportunity_2 <-
  new_groupwise_metric(
    fn = sens,
    name = "equal_opportunity_2",
    aggregate = diff_range
  )
}\if{html}{\out{</div>}}

In \code{aggregate()}, \code{x} is the \code{metric_set()} output with sens values
for each group, and \code{...} gives additional arguments (such as a grouping
level to refer to as the "baseline") to pass to the function outputted
by \code{equal_opportunity_2()} for context.
}

\examples{
library(dplyr)

data(hpc_cv)

head(hpc_cv)

# evaluate `equal_opportunity()` by Resample
m_set <- metric_set(equal_opportunity(Resample))

# use output like any other metric set
hpc_cv \%>\%
  m_set(truth = obs, estimate = pred)

# can mix fairness metrics and regular metrics
m_set_2 <- metric_set(sens, equal_opportunity(Resample))

hpc_cv \%>\%
  m_set_2(truth = obs, estimate = pred)
}
\references{
Hardt, M., Price, E., & Srebro, N. (2016). "Equality of opportunity in
supervised learning". Advances in neural information processing systems, 29.

Verma, S., & Rubin, J. (2018). "Fairness definitions explained". In
Proceedings of the international workshop on software fairness (pp. 1-7).

Bird, S., Dudík, M., Edgar, R., Horn, B., Lutz, R., Milan, V., ... & Walker,
K. (2020). "Fairlearn: A toolkit for assessing and improving fairness in AI".
Microsoft, Tech. Rep. MSR-TR-2020-32.
}
\seealso{
Other fairness metrics: 
\code{\link{demographic_parity}()},
\code{\link{equalized_odds}()}
}
\concept{fairness metrics}
