% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template.R
\name{metric-summarizers}
\alias{metric-summarizers}
\alias{numeric_metric_summarizer}
\alias{class_metric_summarizer}
\alias{prob_metric_summarizer}
\alias{curve_metric_summarizer}
\alias{dynamic_survival_metric_summarizer}
\alias{static_survival_metric_summarizer}
\alias{curve_survival_metric_summarizer}
\title{Developer function for summarizing new metrics}
\usage{
numeric_metric_summarizer(
  name,
  fn,
  data,
  truth,
  estimate,
  ...,
  na_rm = TRUE,
  case_weights = NULL,
  fn_options = list(),
  error_call = caller_env()
)

class_metric_summarizer(
  name,
  fn,
  data,
  truth,
  estimate,
  ...,
  estimator = NULL,
  na_rm = TRUE,
  event_level = NULL,
  case_weights = NULL,
  fn_options = list(),
  error_call = caller_env()
)

prob_metric_summarizer(
  name,
  fn,
  data,
  truth,
  ...,
  estimator = NULL,
  na_rm = TRUE,
  event_level = NULL,
  case_weights = NULL,
  fn_options = list(),
  error_call = caller_env()
)

curve_metric_summarizer(
  name,
  fn,
  data,
  truth,
  ...,
  estimator = NULL,
  na_rm = TRUE,
  event_level = NULL,
  case_weights = NULL,
  fn_options = list(),
  error_call = caller_env()
)

dynamic_survival_metric_summarizer(
  name,
  fn,
  data,
  truth,
  ...,
  na_rm = TRUE,
  case_weights = NULL,
  fn_options = list(),
  error_call = caller_env()
)

static_survival_metric_summarizer(
  name,
  fn,
  data,
  truth,
  estimate,
  ...,
  na_rm = TRUE,
  case_weights = NULL,
  fn_options = list(),
  error_call = caller_env()
)

curve_survival_metric_summarizer(
  name,
  fn,
  data,
  truth,
  ...,
  na_rm = TRUE,
  case_weights = NULL,
  fn_options = list(),
  error_call = caller_env()
)
}
\arguments{
\item{name}{A single character representing the name of the metric to
use in the \code{tibble} output. This will be modified to include the type
of averaging if appropriate.}

\item{fn}{The vector version of your custom metric function. It
generally takes \code{truth}, \code{estimate}, \code{na_rm}, and any other extra arguments
needed to calculate the metric.}

\item{data}{The data frame with \code{truth} and \code{estimate} columns passed in from
the data frame version of your metric function that called
\code{numeric_metric_summarizer()}, \code{class_metric_summarizer()},
\code{prob_metric_summarizer()}, \code{curve_metric_summarizer()},
\code{dynamic_survival_metric_summarizer()}, or
\code{static_survival_metric_summarizer()}.}

\item{truth}{The unquoted column name corresponding to the \code{truth} column.}

\item{estimate}{Generally, the unquoted column name corresponding to
the \code{estimate} column. For metrics that take multiple columns through \code{...}
like class probability metrics, this is a result of \code{\link[=dots_to_estimate]{dots_to_estimate()}}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA} values should be
stripped before the computation proceeds. The removal is executed in
\code{\link[=yardstick_remove_missing]{yardstick_remove_missing()}}.}

\item{case_weights}{For metrics supporting case weights, an unquoted
column name corresponding to case weights can be passed here. If not \code{NULL},
the case weights will be passed on to \code{fn} as the named argument
\code{case_weights}.}

\item{fn_options}{A named list of metric specific options. These
are spliced into the metric function call using \verb{!!!} from \code{rlang}. The
default results in nothing being spliced into the call.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{estimator}{This can either be \code{NULL} for the default auto-selection of
averaging (\code{"binary"} or \code{"macro"}), or a single character to pass along to
the metric implementation describing the kind of averaging to use.}

\item{event_level}{This can either be \code{NULL} to use the default \code{event_level}
value of the \code{fn} or a single string of either \code{"first"} or \code{"second"}
to pass along describing which level should be considered the "event".}
}
\description{
\code{numeric_metric_summarizer()}, \code{class_metric_summarizer()},
\code{prob_metric_summarizer()}, \code{curve_metric_summarizer()},
\code{dynamic_survival_metric_summarizer()}, and
\code{static_survival_metric_summarizer()} are useful alongside \link{check_metric} and
\link{yardstick_remove_missing} for implementing new custom metrics. These
functions call the metric function inside \code{dplyr::summarise()} or
\code{dplyr::reframe()} for \code{curve_metric_summarizer()}. See \href{https://www.tidymodels.org/learn/develop/metrics/}{Custom performance metrics} for more
information.
}
\details{
\code{numeric_metric_summarizer()}, \code{class_metric_summarizer()},
\code{prob_metric_summarizer()}, \code{curve_metric_summarizer()},
\code{dynamic_survival_metric_summarizer()}, and
\code{dynamic_survival_metric_summarizer()} are generally called from the data
frame version of your metric function. It knows how to call your metric over
grouped data frames and returns a \code{tibble} consistent with other metrics.
}
\seealso{
\link{check_metric} \link{yardstick_remove_missing} \code{\link[=finalize_estimator]{finalize_estimator()}} \code{\link[=dots_to_estimate]{dots_to_estimate()}}
}
