% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-msd.R
\name{msd}
\alias{msd}
\alias{msd.data.frame}
\alias{msd_vec}
\title{Mean signed deviation}
\usage{
msd(data, ...)

\method{msd}{data.frame}(data, truth, estimate, na_rm = TRUE, case_weights = NULL, ...)

msd_vec(truth, estimate, na_rm = TRUE, case_weights = NULL, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by the \code{truth}
and \code{estimate} arguments.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights. This
should be an unquoted column name that evaluates to a numeric column in
\code{data}. For \verb{_vec()} functions, a numeric vector.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{msd_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Mean signed deviation (also known as mean signed difference, or mean signed
error) computes the average differences between \code{truth} and \code{estimate}. A
related metric is the mean absolute error (\code{\link[=mae]{mae()}}).
}
\details{
Mean signed deviation is rarely used, since positive and negative errors
cancel each other out. For example, \code{msd_vec(c(100, -100), c(0, 0))} would
return a seemingly "perfect" value of \code{0}, even though \code{estimate} is wildly
different from \code{truth}. \code{\link[=mae]{mae()}} attempts to remedy this by taking the
absolute value of the differences before computing the mean.

This metric is computed as \code{mean(truth - estimate)}, following the convention
that an "error" is computed as \code{observed - predicted}. If you expected this
metric to be computed as \code{mean(estimate - truth)}, reverse the sign of the
result.
}
\examples{
# Supply truth and predictions as bare column names
msd(solubility_test, solubility, prediction)

library(dplyr)

set.seed(1234)
size <- 100
times <- 10

# create 10 resamples
solubility_resampled <- bind_rows(
  replicate(
    n = times,
    expr = sample_n(solubility_test, size, replace = TRUE),
    simplify = FALSE
  ),
  .id = "resample"
)

# Compute the metric by group
metric_results <- solubility_resampled \%>\%
  group_by(resample) \%>\%
  msd(solubility, prediction)

metric_results

# Resampled mean estimate
metric_results \%>\%
  summarise(avg_estimate = mean(.estimate))
}
\seealso{
Other numeric metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{huber_loss}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{mpe}()},
\code{\link{poisson_log_loss}()},
\code{\link{rmse}()},
\code{\link{rpd}()},
\code{\link{rpiq}()},
\code{\link{rsq_trad}()},
\code{\link{rsq}()},
\code{\link{smape}()}

Other accuracy metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{huber_loss}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{mpe}()},
\code{\link{poisson_log_loss}()},
\code{\link{rmse}()},
\code{\link{smape}()}
}
\author{
Thomas Bierhance
}
\concept{accuracy metrics}
\concept{numeric metrics}
