% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob-pr_curve.R
\name{pr_curve}
\alias{pr_curve}
\alias{pr_curve.data.frame}
\alias{autoplot.pr_df}
\title{Precision recall curve}
\usage{
pr_curve(data, ...)

\method{pr_curve}{data.frame}(data, truth, ..., na_rm = TRUE)

autoplot.pr_df(object, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the \code{truth} and \code{estimate}
columns.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected.
Otherwise, there should be as many columns as factor levels of \code{truth}.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{object}{The \code{pr_df} data frame returned from \code{pr_curve()}.}
}
\value{
A tibble with class \code{pr_df} or \code{pr_grouped_df} having
columns \code{.threshold}, \code{recall}, and \code{precision}.
}
\description{
\code{pr_curve()} constructs the full precision recall curve and returns a
tibble. See \code{\link[=pr_auc]{pr_auc()}} for the area under the precision recall curve.
}
\details{
\code{pr_curve()} computes the precision at every unique value of the
probability column (in addition to infinity).

There is a \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}}
method for quickly visualizing the curve. This works for
binary and multiclass output, and also works with grouped data (i.e. from
resamples). See the examples.
}
\section{Multiclass}{


If a multiclass \code{truth} column is provided, a one-vs-all
approach will be taken to calculate multiple curves, one per level.
In this case, there will be an additional column, \code{.level},
identifying the "one" column in the one-vs-all calculation.
}

\section{Relevant Level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result.
In \code{yardstick}, the default is to use the \emph{first} level. To
change this, a global option called \code{yardstick.event_first} is
set to \code{TRUE} when the package is loaded. This can be changed
to \code{FALSE} if the \emph{last} level of the factor is considered the
level of interest by running: \code{options(yardstick.event_first = FALSE)}.
For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\examples{
# ---------------------------------------------------------------------------
# Two class example

# `truth` is a 2 level factor. The first level is `"Class1"`, which is the
# "event of interest" by default in yardstick. See the Relevant Level
# section above.
data(two_class_example)

# Binary metrics using class probabilities take a factor `truth` column,
# and a single class probability column containing the probabilities of
# the event of interest. Here, since `"Class1"` is the first level of
# `"truth"`, it is the event of interest and we pass in probabilities for it.
pr_curve(two_class_example, truth, Class1)

# ---------------------------------------------------------------------------
# `autoplot()`

# Visualize the curve using ggplot2 manually
library(ggplot2)
library(dplyr)
pr_curve(two_class_example, truth, Class1) \%>\%
  ggplot(aes(x = recall, y = precision)) +
  geom_path() +
  coord_equal() +
  theme_bw()

# Or use autoplot
autoplot(pr_curve(two_class_example, truth, Class1))

# Multiclass one-vs-all approach
# One curve per level
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  pr_curve(obs, VF:L) \%>\%
  autoplot()

# Same as above, but will all of the resamples
hpc_cv \%>\%
  group_by(Resample) \%>\%
  pr_curve(obs, VF:L) \%>\%
  autoplot()

}
\seealso{
Compute the area under the precision recall curve with \code{\link[=pr_auc]{pr_auc()}}.

Other curve metrics: 
\code{\link{gain_curve}()},
\code{\link{lift_curve}()},
\code{\link{roc_curve}()}
}
\author{
Max Kuhn
}
\concept{curve metrics}
